package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ApplyCompanyTemplateVersionToStores invokes the cloudesl.ApplyCompanyTemplateVersionToStores API synchronously
func (client *Client) ApplyCompanyTemplateVersionToStores(request *ApplyCompanyTemplateVersionToStoresRequest) (response *ApplyCompanyTemplateVersionToStoresResponse, err error) {
	response = CreateApplyCompanyTemplateVersionToStoresResponse()
	err = client.DoAction(request, response)
	return
}

// ApplyCompanyTemplateVersionToStoresWithChan invokes the cloudesl.ApplyCompanyTemplateVersionToStores API asynchronously
func (client *Client) ApplyCompanyTemplateVersionToStoresWithChan(request *ApplyCompanyTemplateVersionToStoresRequest) (<-chan *ApplyCompanyTemplateVersionToStoresResponse, <-chan error) {
	responseChan := make(chan *ApplyCompanyTemplateVersionToStoresResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ApplyCompanyTemplateVersionToStores(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ApplyCompanyTemplateVersionToStoresWithCallback invokes the cloudesl.ApplyCompanyTemplateVersionToStores API asynchronously
func (client *Client) ApplyCompanyTemplateVersionToStoresWithCallback(request *ApplyCompanyTemplateVersionToStoresRequest, callback func(response *ApplyCompanyTemplateVersionToStoresResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ApplyCompanyTemplateVersionToStoresResponse
		var err error
		defer close(result)
		response, err = client.ApplyCompanyTemplateVersionToStores(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ApplyCompanyTemplateVersionToStoresRequest is the request struct for api ApplyCompanyTemplateVersionToStores
type ApplyCompanyTemplateVersionToStoresRequest struct {
	*requests.RpcRequest
	Stores          string `position:"Body" name:"Stores"`
	TemplateVersion string `position:"Body" name:"TemplateVersion"`
}

// ApplyCompanyTemplateVersionToStoresResponse is the response struct for api ApplyCompanyTemplateVersionToStores
type ApplyCompanyTemplateVersionToStoresResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success        bool   `json:"Success" xml:"Success"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
}

// CreateApplyCompanyTemplateVersionToStoresRequest creates a request to invoke ApplyCompanyTemplateVersionToStores API
func CreateApplyCompanyTemplateVersionToStoresRequest() (request *ApplyCompanyTemplateVersionToStoresRequest) {
	request = &ApplyCompanyTemplateVersionToStoresRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2020-02-01", "ApplyCompanyTemplateVersionToStores", "", "")
	request.Method = requests.POST
	return
}

// CreateApplyCompanyTemplateVersionToStoresResponse creates a response to parse from ApplyCompanyTemplateVersionToStores response
func CreateApplyCompanyTemplateVersionToStoresResponse() (response *ApplyCompanyTemplateVersionToStoresResponse) {
	response = &ApplyCompanyTemplateVersionToStoresResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
