package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddMaterial invokes the cloudesl.AddMaterial API synchronously
func (client *Client) AddMaterial(request *AddMaterialRequest) (response *AddMaterialResponse, err error) {
	response = CreateAddMaterialResponse()
	err = client.DoAction(request, response)
	return
}

// AddMaterialWithChan invokes the cloudesl.AddMaterial API asynchronously
func (client *Client) AddMaterialWithChan(request *AddMaterialRequest) (<-chan *AddMaterialResponse, <-chan error) {
	responseChan := make(chan *AddMaterialResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddMaterial(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddMaterialWithCallback invokes the cloudesl.AddMaterial API asynchronously
func (client *Client) AddMaterialWithCallback(request *AddMaterialRequest, callback func(response *AddMaterialResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddMaterialResponse
		var err error
		defer close(result)
		response, err = client.AddMaterial(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddMaterialRequest is the request struct for api AddMaterial
type AddMaterialRequest struct {
	*requests.RpcRequest
	Content string `position:"Body" name:"Content"`
	Name    string `position:"Body" name:"Name"`
}

// AddMaterialResponse is the response struct for api AddMaterial
type AddMaterialResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Message        string `json:"Message" xml:"Message"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	Code           string `json:"Code" xml:"Code"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	Result         Result `json:"Result" xml:"Result"`
}

// CreateAddMaterialRequest creates a request to invoke AddMaterial API
func CreateAddMaterialRequest() (request *AddMaterialRequest) {
	request = &AddMaterialRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2020-02-01", "AddMaterial", "", "")
	request.Method = requests.POST
	return
}

// CreateAddMaterialResponse creates a response to parse from AddMaterial response
func CreateAddMaterialResponse() (response *AddMaterialResponse) {
	response = &AddMaterialResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
