package cloudauth

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteFaceVerifyResult invokes the cloudauth.DeleteFaceVerifyResult API synchronously
func (client *Client) DeleteFaceVerifyResult(request *DeleteFaceVerifyResultRequest) (response *DeleteFaceVerifyResultResponse, err error) {
	response = CreateDeleteFaceVerifyResultResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteFaceVerifyResultWithChan invokes the cloudauth.DeleteFaceVerifyResult API asynchronously
func (client *Client) DeleteFaceVerifyResultWithChan(request *DeleteFaceVerifyResultRequest) (<-chan *DeleteFaceVerifyResultResponse, <-chan error) {
	responseChan := make(chan *DeleteFaceVerifyResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteFaceVerifyResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteFaceVerifyResultWithCallback invokes the cloudauth.DeleteFaceVerifyResult API asynchronously
func (client *Client) DeleteFaceVerifyResultWithCallback(request *DeleteFaceVerifyResultRequest, callback func(response *DeleteFaceVerifyResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteFaceVerifyResultResponse
		var err error
		defer close(result)
		response, err = client.DeleteFaceVerifyResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteFaceVerifyResultRequest is the request struct for api DeleteFaceVerifyResult
type DeleteFaceVerifyResultRequest struct {
	*requests.RpcRequest
	DeleteAfterQuery string `position:"Query" name:"DeleteAfterQuery"`
	CertifyId        string `position:"Query" name:"CertifyId"`
}

// DeleteFaceVerifyResultResponse is the response struct for api DeleteFaceVerifyResult
type DeleteFaceVerifyResultResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	Code         string       `json:"Code" xml:"Code"`
	Message      string       `json:"Message" xml:"Message"`
	ResultObject ResultObject `json:"ResultObject" xml:"ResultObject"`
}

// CreateDeleteFaceVerifyResultRequest creates a request to invoke DeleteFaceVerifyResult API
func CreateDeleteFaceVerifyResultRequest() (request *DeleteFaceVerifyResultRequest) {
	request = &DeleteFaceVerifyResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudauth", "2019-03-07", "DeleteFaceVerifyResult", "cloudauth", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteFaceVerifyResultResponse creates a response to parse from DeleteFaceVerifyResult response
func CreateDeleteFaceVerifyResultResponse() (response *DeleteFaceVerifyResultResponse) {
	response = &DeleteFaceVerifyResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
