package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateWhiteRuleList invokes the cloud_siem.UpdateWhiteRuleList API synchronously
func (client *Client) UpdateWhiteRuleList(request *UpdateWhiteRuleListRequest) (response *UpdateWhiteRuleListResponse, err error) {
	response = CreateUpdateWhiteRuleListResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateWhiteRuleListWithChan invokes the cloud_siem.UpdateWhiteRuleList API asynchronously
func (client *Client) UpdateWhiteRuleListWithChan(request *UpdateWhiteRuleListRequest) (<-chan *UpdateWhiteRuleListResponse, <-chan error) {
	responseChan := make(chan *UpdateWhiteRuleListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateWhiteRuleList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateWhiteRuleListWithCallback invokes the cloud_siem.UpdateWhiteRuleList API asynchronously
func (client *Client) UpdateWhiteRuleListWithCallback(request *UpdateWhiteRuleListRequest, callback func(response *UpdateWhiteRuleListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateWhiteRuleListResponse
		var err error
		defer close(result)
		response, err = client.UpdateWhiteRuleList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateWhiteRuleListRequest is the request struct for api UpdateWhiteRuleList
type UpdateWhiteRuleListRequest struct {
	*requests.RpcRequest
	WhiteRuleId  requests.Integer `position:"Body" name:"WhiteRuleId"`
	Expression   string           `position:"Body" name:"Expression"`
	IncidentUuid string           `position:"Body" name:"IncidentUuid"`
}

// UpdateWhiteRuleListResponse is the response struct for api UpdateWhiteRuleList
type UpdateWhiteRuleListResponse struct {
	*responses.BaseResponse
}

// CreateUpdateWhiteRuleListRequest creates a request to invoke UpdateWhiteRuleList API
func CreateUpdateWhiteRuleListRequest() (request *UpdateWhiteRuleListRequest) {
	request = &UpdateWhiteRuleListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "UpdateWhiteRuleList", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateWhiteRuleListResponse creates a response to parse from UpdateWhiteRuleList response
func CreateUpdateWhiteRuleListResponse() (response *UpdateWhiteRuleListResponse) {
	response = &UpdateWhiteRuleListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
