package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryPromInstallStatus invokes the arms.QueryPromInstallStatus API synchronously
func (client *Client) QueryPromInstallStatus(request *QueryPromInstallStatusRequest) (response *QueryPromInstallStatusResponse, err error) {
	response = CreateQueryPromInstallStatusResponse()
	err = client.DoAction(request, response)
	return
}

// QueryPromInstallStatusWithChan invokes the arms.QueryPromInstallStatus API asynchronously
func (client *Client) QueryPromInstallStatusWithChan(request *QueryPromInstallStatusRequest) (<-chan *QueryPromInstallStatusResponse, <-chan error) {
	responseChan := make(chan *QueryPromInstallStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryPromInstallStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryPromInstallStatusWithCallback invokes the arms.QueryPromInstallStatus API asynchronously
func (client *Client) QueryPromInstallStatusWithCallback(request *QueryPromInstallStatusRequest, callback func(response *QueryPromInstallStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryPromInstallStatusResponse
		var err error
		defer close(result)
		response, err = client.QueryPromInstallStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryPromInstallStatusRequest is the request struct for api QueryPromInstallStatus
type QueryPromInstallStatusRequest struct {
	*requests.RpcRequest
	ClusterId string `position:"Query" name:"ClusterId"`
}

// QueryPromInstallStatusResponse is the response struct for api QueryPromInstallStatus
type QueryPromInstallStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateQueryPromInstallStatusRequest creates a request to invoke QueryPromInstallStatus API
func CreateQueryPromInstallStatusRequest() (request *QueryPromInstallStatusRequest) {
	request = &QueryPromInstallStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "QueryPromInstallStatus", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryPromInstallStatusResponse creates a response to parse from QueryPromInstallStatus response
func CreateQueryPromInstallStatusResponse() (response *QueryPromInstallStatusResponse) {
	response = &QueryPromInstallStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
