package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSourceMapInfo invokes the arms.GetSourceMapInfo API synchronously
func (client *Client) GetSourceMapInfo(request *GetSourceMapInfoRequest) (response *GetSourceMapInfoResponse, err error) {
	response = CreateGetSourceMapInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetSourceMapInfoWithChan invokes the arms.GetSourceMapInfo API asynchronously
func (client *Client) GetSourceMapInfoWithChan(request *GetSourceMapInfoRequest) (<-chan *GetSourceMapInfoResponse, <-chan error) {
	responseChan := make(chan *GetSourceMapInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSourceMapInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSourceMapInfoWithCallback invokes the arms.GetSourceMapInfo API asynchronously
func (client *Client) GetSourceMapInfoWithCallback(request *GetSourceMapInfoRequest, callback func(response *GetSourceMapInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSourceMapInfoResponse
		var err error
		defer close(result)
		response, err = client.GetSourceMapInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSourceMapInfoRequest is the request struct for api GetSourceMapInfo
type GetSourceMapInfoRequest struct {
	*requests.RpcRequest
	Edition           string           `position:"Query" name:"Edition"`
	Version           string           `position:"Query" name:"Version"`
	ID                string           `position:"Query" name:"ID"`
	Keyword           string           `position:"Query" name:"Keyword"`
	AscendingSequence requests.Boolean `position:"Query" name:"AscendingSequence"`
	OrderField        string           `position:"Query" name:"OrderField"`
}

// GetSourceMapInfoResponse is the response struct for api GetSourceMapInfo
type GetSourceMapInfoResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	SourceMapList []Data `json:"SourceMapList" xml:"SourceMapList"`
}

// CreateGetSourceMapInfoRequest creates a request to invoke GetSourceMapInfo API
func CreateGetSourceMapInfoRequest() (request *GetSourceMapInfoRequest) {
	request = &GetSourceMapInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "GetSourceMapInfo", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetSourceMapInfoResponse creates a response to parse from GetSourceMapInfo response
func CreateGetSourceMapInfoResponse() (response *GetSourceMapInfoResponse) {
	response = &GetSourceMapInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
