package appstream_center

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListNodeInstanceType invokes the appstream_center.ListNodeInstanceType API synchronously
func (client *Client) ListNodeInstanceType(request *ListNodeInstanceTypeRequest) (response *ListNodeInstanceTypeResponse, err error) {
	response = CreateListNodeInstanceTypeResponse()
	err = client.DoAction(request, response)
	return
}

// ListNodeInstanceTypeWithChan invokes the appstream_center.ListNodeInstanceType API asynchronously
func (client *Client) ListNodeInstanceTypeWithChan(request *ListNodeInstanceTypeRequest) (<-chan *ListNodeInstanceTypeResponse, <-chan error) {
	responseChan := make(chan *ListNodeInstanceTypeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListNodeInstanceType(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListNodeInstanceTypeWithCallback invokes the appstream_center.ListNodeInstanceType API asynchronously
func (client *Client) ListNodeInstanceTypeWithCallback(request *ListNodeInstanceTypeRequest, callback func(response *ListNodeInstanceTypeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListNodeInstanceTypeResponse
		var err error
		defer close(result)
		response, err = client.ListNodeInstanceType(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListNodeInstanceTypeRequest is the request struct for api ListNodeInstanceType
type ListNodeInstanceTypeRequest struct {
	*requests.RpcRequest
	BizRegionId string           `position:"Query" name:"BizRegionId"`
	Language    string           `position:"Query" name:"Language"`
	OsType      string           `position:"Query" name:"OsType"`
	PageNumber  requests.Integer `position:"Query" name:"PageNumber"`
	ProductType string           `position:"Query" name:"ProductType"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
}

// ListNodeInstanceTypeResponse is the response struct for api ListNodeInstanceType
type ListNodeInstanceTypeResponse struct {
	*responses.BaseResponse
	RequestId              string `json:"RequestId" xml:"RequestId"`
	TotalCount             int    `json:"TotalCount" xml:"TotalCount"`
	PageSize               int    `json:"PageSize" xml:"PageSize"`
	PageNumber             int    `json:"PageNumber" xml:"PageNumber"`
	NodeInstanceTypeModels []Node `json:"NodeInstanceTypeModels" xml:"NodeInstanceTypeModels"`
}

// CreateListNodeInstanceTypeRequest creates a request to invoke ListNodeInstanceType API
func CreateListNodeInstanceTypeRequest() (request *ListNodeInstanceTypeRequest) {
	request = &ListNodeInstanceTypeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("appstream-center", "2021-09-01", "ListNodeInstanceType", "", "")
	request.Method = requests.POST
	return
}

// CreateListNodeInstanceTypeResponse creates a response to parse from ListNodeInstanceType response
func CreateListNodeInstanceTypeResponse() (response *ListNodeInstanceTypeResponse) {
	response = &ListNodeInstanceTypeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
