package alinlp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetKeywordEnEcom invokes the alinlp.GetKeywordEnEcom API synchronously
func (client *Client) GetKeywordEnEcom(request *GetKeywordEnEcomRequest) (response *GetKeywordEnEcomResponse, err error) {
	response = CreateGetKeywordEnEcomResponse()
	err = client.DoAction(request, response)
	return
}

// GetKeywordEnEcomWithChan invokes the alinlp.GetKeywordEnEcom API asynchronously
func (client *Client) GetKeywordEnEcomWithChan(request *GetKeywordEnEcomRequest) (<-chan *GetKeywordEnEcomResponse, <-chan error) {
	responseChan := make(chan *GetKeywordEnEcomResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetKeywordEnEcom(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetKeywordEnEcomWithCallback invokes the alinlp.GetKeywordEnEcom API asynchronously
func (client *Client) GetKeywordEnEcomWithCallback(request *GetKeywordEnEcomRequest, callback func(response *GetKeywordEnEcomResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetKeywordEnEcomResponse
		var err error
		defer close(result)
		response, err = client.GetKeywordEnEcom(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetKeywordEnEcomRequest is the request struct for api GetKeywordEnEcom
type GetKeywordEnEcomRequest struct {
	*requests.RpcRequest
	ServiceCode string `position:"Body" name:"ServiceCode"`
	Text        string `position:"Body" name:"Text"`
}

// GetKeywordEnEcomResponse is the response struct for api GetKeywordEnEcom
type GetKeywordEnEcomResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetKeywordEnEcomRequest creates a request to invoke GetKeywordEnEcom API
func CreateGetKeywordEnEcomRequest() (request *GetKeywordEnEcomRequest) {
	request = &GetKeywordEnEcomRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alinlp", "2020-06-29", "GetKeywordEnEcom", "alinlp", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetKeywordEnEcomResponse creates a response to parse from GetKeywordEnEcom response
func CreateGetKeywordEnEcomResponse() (response *GetKeywordEnEcomResponse) {
	response = &GetKeywordEnEcomResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
