package alikafka

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableAutoGroupCreation invokes the alikafka.EnableAutoGroupCreation API synchronously
func (client *Client) EnableAutoGroupCreation(request *EnableAutoGroupCreationRequest) (response *EnableAutoGroupCreationResponse, err error) {
	response = CreateEnableAutoGroupCreationResponse()
	err = client.DoAction(request, response)
	return
}

// EnableAutoGroupCreationWithChan invokes the alikafka.EnableAutoGroupCreation API asynchronously
func (client *Client) EnableAutoGroupCreationWithChan(request *EnableAutoGroupCreationRequest) (<-chan *EnableAutoGroupCreationResponse, <-chan error) {
	responseChan := make(chan *EnableAutoGroupCreationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableAutoGroupCreation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableAutoGroupCreationWithCallback invokes the alikafka.EnableAutoGroupCreation API asynchronously
func (client *Client) EnableAutoGroupCreationWithCallback(request *EnableAutoGroupCreationRequest, callback func(response *EnableAutoGroupCreationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableAutoGroupCreationResponse
		var err error
		defer close(result)
		response, err = client.EnableAutoGroupCreation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableAutoGroupCreationRequest is the request struct for api EnableAutoGroupCreation
type EnableAutoGroupCreationRequest struct {
	*requests.RpcRequest
	InstanceId string           `position:"Query" name:"InstanceId"`
	Enable     requests.Boolean `position:"Query" name:"Enable"`
}

// EnableAutoGroupCreationResponse is the response struct for api EnableAutoGroupCreation
type EnableAutoGroupCreationResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateEnableAutoGroupCreationRequest creates a request to invoke EnableAutoGroupCreation API
func CreateEnableAutoGroupCreationRequest() (request *EnableAutoGroupCreationRequest) {
	request = &EnableAutoGroupCreationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alikafka", "2019-09-16", "EnableAutoGroupCreation", "alikafka", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEnableAutoGroupCreationResponse creates a response to parse from EnableAutoGroupCreation response
func CreateEnableAutoGroupCreationResponse() (response *EnableAutoGroupCreationResponse) {
	response = &EnableAutoGroupCreationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
