package alb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSecurityPolicies invokes the alb.ListSecurityPolicies API synchronously
func (client *Client) ListSecurityPolicies(request *ListSecurityPoliciesRequest) (response *ListSecurityPoliciesResponse, err error) {
	response = CreateListSecurityPoliciesResponse()
	err = client.DoAction(request, response)
	return
}

// ListSecurityPoliciesWithChan invokes the alb.ListSecurityPolicies API asynchronously
func (client *Client) ListSecurityPoliciesWithChan(request *ListSecurityPoliciesRequest) (<-chan *ListSecurityPoliciesResponse, <-chan error) {
	responseChan := make(chan *ListSecurityPoliciesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSecurityPolicies(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSecurityPoliciesWithCallback invokes the alb.ListSecurityPolicies API asynchronously
func (client *Client) ListSecurityPoliciesWithCallback(request *ListSecurityPoliciesRequest, callback func(response *ListSecurityPoliciesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSecurityPoliciesResponse
		var err error
		defer close(result)
		response, err = client.ListSecurityPolicies(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSecurityPoliciesRequest is the request struct for api ListSecurityPolicies
type ListSecurityPoliciesRequest struct {
	*requests.RpcRequest
	SecurityPolicyNames *[]string                  `position:"Query" name:"SecurityPolicyNames"  type:"Repeated"`
	ResourceGroupId     string                     `position:"Query" name:"ResourceGroupId"`
	NextToken           string                     `position:"Query" name:"NextToken"`
	Tag                 *[]ListSecurityPoliciesTag `position:"Query" name:"Tag"  type:"Repeated"`
	SecurityPolicyIds   *[]string                  `position:"Query" name:"SecurityPolicyIds"  type:"Repeated"`
	MaxResults          requests.Integer           `position:"Query" name:"MaxResults"`
}

// ListSecurityPoliciesTag is a repeated param struct in ListSecurityPoliciesRequest
type ListSecurityPoliciesTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// ListSecurityPoliciesResponse is the response struct for api ListSecurityPolicies
type ListSecurityPoliciesResponse struct {
	*responses.BaseResponse
	MaxResults       int              `json:"MaxResults" xml:"MaxResults"`
	NextToken        string           `json:"NextToken" xml:"NextToken"`
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	TotalCount       int              `json:"TotalCount" xml:"TotalCount"`
	SecurityPolicies []SecurityPolicy `json:"SecurityPolicies" xml:"SecurityPolicies"`
}

// CreateListSecurityPoliciesRequest creates a request to invoke ListSecurityPolicies API
func CreateListSecurityPoliciesRequest() (request *ListSecurityPoliciesRequest) {
	request = &ListSecurityPoliciesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alb", "2020-06-16", "ListSecurityPolicies", "alb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListSecurityPoliciesResponse creates a response to parse from ListSecurityPolicies response
func CreateListSecurityPoliciesResponse() (response *ListSecurityPoliciesResponse) {
	response = &ListSecurityPoliciesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
