package alb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListHealthCheckTemplates invokes the alb.ListHealthCheckTemplates API synchronously
func (client *Client) ListHealthCheckTemplates(request *ListHealthCheckTemplatesRequest) (response *ListHealthCheckTemplatesResponse, err error) {
	response = CreateListHealthCheckTemplatesResponse()
	err = client.DoAction(request, response)
	return
}

// ListHealthCheckTemplatesWithChan invokes the alb.ListHealthCheckTemplates API asynchronously
func (client *Client) ListHealthCheckTemplatesWithChan(request *ListHealthCheckTemplatesRequest) (<-chan *ListHealthCheckTemplatesResponse, <-chan error) {
	responseChan := make(chan *ListHealthCheckTemplatesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListHealthCheckTemplates(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListHealthCheckTemplatesWithCallback invokes the alb.ListHealthCheckTemplates API asynchronously
func (client *Client) ListHealthCheckTemplatesWithCallback(request *ListHealthCheckTemplatesRequest, callback func(response *ListHealthCheckTemplatesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListHealthCheckTemplatesResponse
		var err error
		defer close(result)
		response, err = client.ListHealthCheckTemplates(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListHealthCheckTemplatesRequest is the request struct for api ListHealthCheckTemplates
type ListHealthCheckTemplatesRequest struct {
	*requests.RpcRequest
	NextToken                string                         `position:"Query" name:"NextToken"`
	Tag                      *[]ListHealthCheckTemplatesTag `position:"Query" name:"Tag"  type:"Repeated"`
	HealthCheckTemplateNames *[]string                      `position:"Query" name:"HealthCheckTemplateNames"  type:"Repeated"`
	MaxResults               requests.Integer               `position:"Query" name:"MaxResults"`
	HealthCheckTemplateIds   *[]string                      `position:"Query" name:"HealthCheckTemplateIds"  type:"Repeated"`
}

// ListHealthCheckTemplatesTag is a repeated param struct in ListHealthCheckTemplatesRequest
type ListHealthCheckTemplatesTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// ListHealthCheckTemplatesResponse is the response struct for api ListHealthCheckTemplates
type ListHealthCheckTemplatesResponse struct {
	*responses.BaseResponse
	MaxResults           int                   `json:"MaxResults" xml:"MaxResults"`
	NextToken            string                `json:"NextToken" xml:"NextToken"`
	RequestId            string                `json:"RequestId" xml:"RequestId"`
	TotalCount           int                   `json:"TotalCount" xml:"TotalCount"`
	HealthCheckTemplates []HealthCheckTemplate `json:"HealthCheckTemplates" xml:"HealthCheckTemplates"`
}

// CreateListHealthCheckTemplatesRequest creates a request to invoke ListHealthCheckTemplates API
func CreateListHealthCheckTemplatesRequest() (request *ListHealthCheckTemplatesRequest) {
	request = &ListHealthCheckTemplatesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alb", "2020-06-16", "ListHealthCheckTemplates", "alb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListHealthCheckTemplatesResponse creates a response to parse from ListHealthCheckTemplates response
func CreateListHealthCheckTemplatesResponse() (response *ListHealthCheckTemplatesResponse) {
	response = &ListHealthCheckTemplatesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
