package aimath

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateStep invokes the aimath.UpdateStep API synchronously
func (client *Client) UpdateStep(request *UpdateStepRequest) (response *UpdateStepResponse, err error) {
	response = CreateUpdateStepResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateStepWithChan invokes the aimath.UpdateStep API asynchronously
func (client *Client) UpdateStepWithChan(request *UpdateStepRequest) (<-chan *UpdateStepResponse, <-chan error) {
	responseChan := make(chan *UpdateStepResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateStep(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateStepWithCallback invokes the aimath.UpdateStep API asynchronously
func (client *Client) UpdateStepWithCallback(request *UpdateStepRequest, callback func(response *UpdateStepResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateStepResponse
		var err error
		defer close(result)
		response, err = client.UpdateStep(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateStepRequest is the request struct for api UpdateStep
type UpdateStepRequest struct {
	*requests.RpcRequest
	Content      string `position:"Body" name:"Content"`
	ContentCode  string `position:"Body" name:"ContentCode"`
	ExerciseCode string `position:"Body" name:"ExerciseCode"`
}

// UpdateStepResponse is the response struct for api UpdateStep
type UpdateStepResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	ErrCode   string `json:"ErrCode" xml:"ErrCode"`
	ErrMsg    string `json:"ErrMsg" xml:"ErrMsg"`
}

// CreateUpdateStepRequest creates a request to invoke UpdateStep API
func CreateUpdateStepRequest() (request *UpdateStepRequest) {
	request = &UpdateStepRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("AIMath", "2024-11-14", "UpdateStep", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateStepResponse creates a response to parse from UpdateStep response
func CreateUpdateStepResponse() (response *UpdateStepResponse) {
	response = &UpdateStepResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
