package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListEnhanhcedNatGatewayAvailableZones invokes the vpc.ListEnhanhcedNatGatewayAvailableZones API synchronously
func (client *Client) ListEnhanhcedNatGatewayAvailableZones(request *ListEnhanhcedNatGatewayAvailableZonesRequest) (response *ListEnhanhcedNatGatewayAvailableZonesResponse, err error) {
	response = CreateListEnhanhcedNatGatewayAvailableZonesResponse()
	err = client.DoAction(request, response)
	return
}

// ListEnhanhcedNatGatewayAvailableZonesWithChan invokes the vpc.ListEnhanhcedNatGatewayAvailableZones API asynchronously
func (client *Client) ListEnhanhcedNatGatewayAvailableZonesWithChan(request *ListEnhanhcedNatGatewayAvailableZonesRequest) (<-chan *ListEnhanhcedNatGatewayAvailableZonesResponse, <-chan error) {
	responseChan := make(chan *ListEnhanhcedNatGatewayAvailableZonesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListEnhanhcedNatGatewayAvailableZones(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListEnhanhcedNatGatewayAvailableZonesWithCallback invokes the vpc.ListEnhanhcedNatGatewayAvailableZones API asynchronously
func (client *Client) ListEnhanhcedNatGatewayAvailableZonesWithCallback(request *ListEnhanhcedNatGatewayAvailableZonesRequest, callback func(response *ListEnhanhcedNatGatewayAvailableZonesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListEnhanhcedNatGatewayAvailableZonesResponse
		var err error
		defer close(result)
		response, err = client.ListEnhanhcedNatGatewayAvailableZones(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListEnhanhcedNatGatewayAvailableZonesRequest is the request struct for api ListEnhanhcedNatGatewayAvailableZones
type ListEnhanhcedNatGatewayAvailableZonesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer                               `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string                                         `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string                                         `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer                               `position:"Query" name:"OwnerId"`
	Filter               *[]ListEnhanhcedNatGatewayAvailableZonesFilter `position:"Query" name:"Filter"  type:"Repeated"`
	AcceptLanguage       string                                         `position:"Query" name:"AcceptLanguage"`
}

// ListEnhanhcedNatGatewayAvailableZonesFilter is a repeated param struct in ListEnhanhcedNatGatewayAvailableZonesRequest
type ListEnhanhcedNatGatewayAvailableZonesFilter struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// ListEnhanhcedNatGatewayAvailableZonesResponse is the response struct for api ListEnhanhcedNatGatewayAvailableZones
type ListEnhanhcedNatGatewayAvailableZonesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Zones     []Zone `json:"Zones" xml:"Zones"`
}

// CreateListEnhanhcedNatGatewayAvailableZonesRequest creates a request to invoke ListEnhanhcedNatGatewayAvailableZones API
func CreateListEnhanhcedNatGatewayAvailableZonesRequest() (request *ListEnhanhcedNatGatewayAvailableZonesRequest) {
	request = &ListEnhanhcedNatGatewayAvailableZonesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "ListEnhanhcedNatGatewayAvailableZones", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListEnhanhcedNatGatewayAvailableZonesResponse creates a response to parse from ListEnhanhcedNatGatewayAvailableZones response
func CreateListEnhanhcedNatGatewayAvailableZonesResponse() (response *ListEnhanhcedNatGatewayAvailableZonesResponse) {
	response = &ListEnhanhcedNatGatewayAvailableZonesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
