package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetVSwitchCidrReservationUsage invokes the vpc.GetVSwitchCidrReservationUsage API synchronously
func (client *Client) GetVSwitchCidrReservationUsage(request *GetVSwitchCidrReservationUsageRequest) (response *GetVSwitchCidrReservationUsageResponse, err error) {
	response = CreateGetVSwitchCidrReservationUsageResponse()
	err = client.DoAction(request, response)
	return
}

// GetVSwitchCidrReservationUsageWithChan invokes the vpc.GetVSwitchCidrReservationUsage API asynchronously
func (client *Client) GetVSwitchCidrReservationUsageWithChan(request *GetVSwitchCidrReservationUsageRequest) (<-chan *GetVSwitchCidrReservationUsageResponse, <-chan error) {
	responseChan := make(chan *GetVSwitchCidrReservationUsageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetVSwitchCidrReservationUsage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetVSwitchCidrReservationUsageWithCallback invokes the vpc.GetVSwitchCidrReservationUsage API asynchronously
func (client *Client) GetVSwitchCidrReservationUsageWithCallback(request *GetVSwitchCidrReservationUsageRequest, callback func(response *GetVSwitchCidrReservationUsageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetVSwitchCidrReservationUsageResponse
		var err error
		defer close(result)
		response, err = client.GetVSwitchCidrReservationUsage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetVSwitchCidrReservationUsageRequest is the request struct for api GetVSwitchCidrReservationUsage
type GetVSwitchCidrReservationUsageRequest struct {
	*requests.RpcRequest
	ResourceOwnerId          requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount     string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount             string           `position:"Query" name:"OwnerAccount"`
	OwnerId                  requests.Integer `position:"Query" name:"OwnerId"`
	NextToken                string           `position:"Query" name:"NextToken"`
	MaxResults               requests.Integer `position:"Query" name:"MaxResults"`
	VSwitchCidrReservationId string           `position:"Query" name:"VSwitchCidrReservationId"`
}

// GetVSwitchCidrReservationUsageResponse is the response struct for api GetVSwitchCidrReservationUsage
type GetVSwitchCidrReservationUsageResponse struct {
	*responses.BaseResponse
	RequestId             string                        `json:"RequestId" xml:"RequestId"`
	NextToken             string                        `json:"NextToken" xml:"NextToken"`
	TotalCount            int64                         `json:"TotalCount" xml:"TotalCount"`
	MaxResults            int64                         `json:"MaxResults" xml:"MaxResults"`
	CidrReservationUsages []VSwitchCidrReservationUsage `json:"CidrReservationUsages" xml:"CidrReservationUsages"`
}

// CreateGetVSwitchCidrReservationUsageRequest creates a request to invoke GetVSwitchCidrReservationUsage API
func CreateGetVSwitchCidrReservationUsageRequest() (request *GetVSwitchCidrReservationUsageRequest) {
	request = &GetVSwitchCidrReservationUsageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "GetVSwitchCidrReservationUsage", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetVSwitchCidrReservationUsageResponse creates a response to parse from GetVSwitchCidrReservationUsage response
func CreateGetVSwitchCidrReservationUsageResponse() (response *GetVSwitchCidrReservationUsageResponse) {
	response = &GetVSwitchCidrReservationUsageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
