package voicenavigator

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyTTSConfig invokes the voicenavigator.ModifyTTSConfig API synchronously
func (client *Client) ModifyTTSConfig(request *ModifyTTSConfigRequest) (response *ModifyTTSConfigResponse, err error) {
	response = CreateModifyTTSConfigResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyTTSConfigWithChan invokes the voicenavigator.ModifyTTSConfig API asynchronously
func (client *Client) ModifyTTSConfigWithChan(request *ModifyTTSConfigRequest) (<-chan *ModifyTTSConfigResponse, <-chan error) {
	responseChan := make(chan *ModifyTTSConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyTTSConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyTTSConfigWithCallback invokes the voicenavigator.ModifyTTSConfig API asynchronously
func (client *Client) ModifyTTSConfigWithCallback(request *ModifyTTSConfigRequest, callback func(response *ModifyTTSConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyTTSConfigResponse
		var err error
		defer close(result)
		response, err = client.ModifyTTSConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyTTSConfigRequest is the request struct for api ModifyTTSConfig
type ModifyTTSConfigRequest struct {
	*requests.RpcRequest
	Voice      string `position:"Query" name:"Voice"`
	Volume     string `position:"Query" name:"Volume"`
	InstanceId string `position:"Query" name:"InstanceId"`
	SpeechRate string `position:"Query" name:"SpeechRate"`
}

// ModifyTTSConfigResponse is the response struct for api ModifyTTSConfig
type ModifyTTSConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyTTSConfigRequest creates a request to invoke ModifyTTSConfig API
func CreateModifyTTSConfigRequest() (request *ModifyTTSConfigRequest) {
	request = &ModifyTTSConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("VoiceNavigator", "2018-06-12", "ModifyTTSConfig", "voicebot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyTTSConfigResponse creates a response to parse from ModifyTTSConfig response
func CreateModifyTTSConfigResponse() (response *ModifyTTSConfigResponse) {
	response = &ModifyTTSConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
