package ververica

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateSavepoint invokes the ververica.CreateSavepoint API synchronously
func (client *Client) CreateSavepoint(request *CreateSavepointRequest) (response *CreateSavepointResponse, err error) {
	response = CreateCreateSavepointResponse()
	err = client.DoAction(request, response)
	return
}

// CreateSavepointWithChan invokes the ververica.CreateSavepoint API asynchronously
func (client *Client) CreateSavepointWithChan(request *CreateSavepointRequest) (<-chan *CreateSavepointResponse, <-chan error) {
	responseChan := make(chan *CreateSavepointResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateSavepoint(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateSavepointWithCallback invokes the ververica.CreateSavepoint API asynchronously
func (client *Client) CreateSavepointWithCallback(request *CreateSavepointRequest, callback func(response *CreateSavepointResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateSavepointResponse
		var err error
		defer close(result)
		response, err = client.CreateSavepoint(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateSavepointRequest is the request struct for api CreateSavepoint
type CreateSavepointRequest struct {
	*requests.RoaRequest
	Workspace  string `position:"Path" name:"workspace"`
	ParamsJson string `position:"Body" name:"paramsJson"`
	Namespace  string `position:"Path" name:"namespace"`
}

// CreateSavepointResponse is the response struct for api CreateSavepoint
type CreateSavepointResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"success" xml:"success"`
	Data      string `json:"data" xml:"data"`
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateCreateSavepointRequest creates a request to invoke CreateSavepoint API
func CreateCreateSavepointRequest() (request *CreateSavepointRequest) {
	request = &CreateSavepointRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("ververica", "2020-05-01", "CreateSavepoint", "/pop/workspaces/[workspace]/api/v1/namespaces/[namespace]/savepoints", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateSavepointResponse creates a response to parse from CreateSavepoint response
func CreateCreateSavepointResponse() (response *CreateSavepointResponse) {
	response = &CreateSavepointResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
