package swas_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyFirewallRule invokes the swas_open.ModifyFirewallRule API synchronously
func (client *Client) ModifyFirewallRule(request *ModifyFirewallRuleRequest) (response *ModifyFirewallRuleResponse, err error) {
	response = CreateModifyFirewallRuleResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyFirewallRuleWithChan invokes the swas_open.ModifyFirewallRule API asynchronously
func (client *Client) ModifyFirewallRuleWithChan(request *ModifyFirewallRuleRequest) (<-chan *ModifyFirewallRuleResponse, <-chan error) {
	responseChan := make(chan *ModifyFirewallRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyFirewallRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyFirewallRuleWithCallback invokes the swas_open.ModifyFirewallRule API asynchronously
func (client *Client) ModifyFirewallRuleWithCallback(request *ModifyFirewallRuleRequest, callback func(response *ModifyFirewallRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyFirewallRuleResponse
		var err error
		defer close(result)
		response, err = client.ModifyFirewallRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyFirewallRuleRequest is the request struct for api ModifyFirewallRule
type ModifyFirewallRuleRequest struct {
	*requests.RpcRequest
	ClientToken  string `position:"Query" name:"ClientToken"`
	Remark       string `position:"Query" name:"Remark"`
	SourceCidrIp string `position:"Query" name:"SourceCidrIp"`
	InstanceId   string `position:"Query" name:"InstanceId"`
	RuleProtocol string `position:"Query" name:"RuleProtocol"`
	Port         string `position:"Query" name:"Port"`
	RuleId       string `position:"Query" name:"RuleId"`
}

// ModifyFirewallRuleResponse is the response struct for api ModifyFirewallRule
type ModifyFirewallRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyFirewallRuleRequest creates a request to invoke ModifyFirewallRule API
func CreateModifyFirewallRuleRequest() (request *ModifyFirewallRuleRequest) {
	request = &ModifyFirewallRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SWAS-OPEN", "2020-06-01", "ModifyFirewallRule", "SWAS-OPEN", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyFirewallRuleResponse creates a response to parse from ModifyFirewallRule response
func CreateModifyFirewallRuleResponse() (response *ModifyFirewallRuleResponse) {
	response = &ModifyFirewallRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
