package swas_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDatabaseSlowLogRecords invokes the swas_open.DescribeDatabaseSlowLogRecords API synchronously
func (client *Client) DescribeDatabaseSlowLogRecords(request *DescribeDatabaseSlowLogRecordsRequest) (response *DescribeDatabaseSlowLogRecordsResponse, err error) {
	response = CreateDescribeDatabaseSlowLogRecordsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDatabaseSlowLogRecordsWithChan invokes the swas_open.DescribeDatabaseSlowLogRecords API asynchronously
func (client *Client) DescribeDatabaseSlowLogRecordsWithChan(request *DescribeDatabaseSlowLogRecordsRequest) (<-chan *DescribeDatabaseSlowLogRecordsResponse, <-chan error) {
	responseChan := make(chan *DescribeDatabaseSlowLogRecordsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDatabaseSlowLogRecords(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDatabaseSlowLogRecordsWithCallback invokes the swas_open.DescribeDatabaseSlowLogRecords API asynchronously
func (client *Client) DescribeDatabaseSlowLogRecordsWithCallback(request *DescribeDatabaseSlowLogRecordsRequest, callback func(response *DescribeDatabaseSlowLogRecordsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDatabaseSlowLogRecordsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDatabaseSlowLogRecords(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDatabaseSlowLogRecordsRequest is the request struct for api DescribeDatabaseSlowLogRecords
type DescribeDatabaseSlowLogRecordsRequest struct {
	*requests.RpcRequest
	DatabaseInstanceId string           `position:"Query" name:"DatabaseInstanceId"`
	EndTime            string           `position:"Query" name:"EndTime"`
	StartTime          string           `position:"Query" name:"StartTime"`
	PageNumber         requests.Integer `position:"Query" name:"PageNumber"`
	PageSize           requests.Integer `position:"Query" name:"PageSize"`
}

// DescribeDatabaseSlowLogRecordsResponse is the response struct for api DescribeDatabaseSlowLogRecords
type DescribeDatabaseSlowLogRecordsResponse struct {
	*responses.BaseResponse
	RequestId      string    `json:"RequestId" xml:"RequestId"`
	PageNumber     int       `json:"PageNumber" xml:"PageNumber"`
	PageSize       int       `json:"PageSize" xml:"PageSize"`
	TotalCount     int       `json:"TotalCount" xml:"TotalCount"`
	PhysicalIORead int64     `json:"PhysicalIORead" xml:"PhysicalIORead"`
	Engine         string    `json:"Engine" xml:"Engine"`
	SlowLogs       []SlowLog `json:"SlowLogs" xml:"SlowLogs"`
}

// CreateDescribeDatabaseSlowLogRecordsRequest creates a request to invoke DescribeDatabaseSlowLogRecords API
func CreateDescribeDatabaseSlowLogRecordsRequest() (request *DescribeDatabaseSlowLogRecordsRequest) {
	request = &DescribeDatabaseSlowLogRecordsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SWAS-OPEN", "2020-06-01", "DescribeDatabaseSlowLogRecords", "SWAS-OPEN", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDatabaseSlowLogRecordsResponse creates a response to parse from DescribeDatabaseSlowLogRecords response
func CreateDescribeDatabaseSlowLogRecordsResponse() (response *DescribeDatabaseSlowLogRecordsResponse) {
	response = &DescribeDatabaseSlowLogRecordsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
