package retailadvqa_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetInstanceInstance invokes the retailadvqa_public.GetInstanceInstance API synchronously
func (client *Client) GetInstanceInstance(request *GetInstanceInstanceRequest) (response *GetInstanceInstanceResponse, err error) {
	response = CreateGetInstanceInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// GetInstanceInstanceWithChan invokes the retailadvqa_public.GetInstanceInstance API asynchronously
func (client *Client) GetInstanceInstanceWithChan(request *GetInstanceInstanceRequest) (<-chan *GetInstanceInstanceResponse, <-chan error) {
	responseChan := make(chan *GetInstanceInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetInstanceInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetInstanceInstanceWithCallback invokes the retailadvqa_public.GetInstanceInstance API asynchronously
func (client *Client) GetInstanceInstanceWithCallback(request *GetInstanceInstanceRequest, callback func(response *GetInstanceInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetInstanceInstanceResponse
		var err error
		defer close(result)
		response, err = client.GetInstanceInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetInstanceInstanceRequest is the request struct for api GetInstanceInstance
type GetInstanceInstanceRequest struct {
	*requests.RpcRequest
	AccessId    string `position:"Query" name:"AccessId"`
	AccountId   string `position:"Query" name:"AccountId"`
	AccountName string `position:"Query" name:"AccountName"`
}

// GetInstanceInstanceResponse is the response struct for api GetInstanceInstance
type GetInstanceInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Success   string `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetInstanceInstanceRequest creates a request to invoke GetInstanceInstance API
func CreateGetInstanceInstanceRequest() (request *GetInstanceInstanceRequest) {
	request = &GetInstanceInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailadvqa-public", "2020-05-15", "GetInstanceInstance", "", "")
	request.Method = requests.POST
	return
}

// CreateGetInstanceInstanceResponse creates a response to parse from GetInstanceInstance response
func CreateGetInstanceInstanceResponse() (response *GetInstanceInstanceResponse) {
	response = &GetInstanceInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
