package resourcemanager

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableResourceDirectory invokes the resourcemanager.EnableResourceDirectory API synchronously
func (client *Client) EnableResourceDirectory(request *EnableResourceDirectoryRequest) (response *EnableResourceDirectoryResponse, err error) {
	response = CreateEnableResourceDirectoryResponse()
	err = client.DoAction(request, response)
	return
}

// EnableResourceDirectoryWithChan invokes the resourcemanager.EnableResourceDirectory API asynchronously
func (client *Client) EnableResourceDirectoryWithChan(request *EnableResourceDirectoryRequest) (<-chan *EnableResourceDirectoryResponse, <-chan error) {
	responseChan := make(chan *EnableResourceDirectoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableResourceDirectory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableResourceDirectoryWithCallback invokes the resourcemanager.EnableResourceDirectory API asynchronously
func (client *Client) EnableResourceDirectoryWithCallback(request *EnableResourceDirectoryRequest, callback func(response *EnableResourceDirectoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableResourceDirectoryResponse
		var err error
		defer close(result)
		response, err = client.EnableResourceDirectory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableResourceDirectoryRequest is the request struct for api EnableResourceDirectory
type EnableResourceDirectoryRequest struct {
	*requests.RpcRequest
	EnableMode          string `position:"Query" name:"EnableMode"`
	MASecureMobilePhone string `position:"Query" name:"MASecureMobilePhone"`
	MAName              string `position:"Query" name:"MAName"`
	VerificationCode    string `position:"Query" name:"VerificationCode"`
}

// EnableResourceDirectoryResponse is the response struct for api EnableResourceDirectory
type EnableResourceDirectoryResponse struct {
	*responses.BaseResponse
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	ResourceDirectory ResourceDirectory `json:"ResourceDirectory" xml:"ResourceDirectory"`
}

// CreateEnableResourceDirectoryRequest creates a request to invoke EnableResourceDirectory API
func CreateEnableResourceDirectoryRequest() (request *EnableResourceDirectoryRequest) {
	request = &EnableResourceDirectoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceManager", "2020-03-31", "EnableResourceDirectory", "resourcemanager", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEnableResourceDirectoryResponse creates a response to parse from EnableResourceDirectory response
func CreateEnableResourceDirectoryResponse() (response *EnableResourceDirectoryResponse) {
	response = &EnableResourceDirectoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
