package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyEventInfo invokes the rds.ModifyEventInfo API synchronously
func (client *Client) ModifyEventInfo(request *ModifyEventInfoRequest) (response *ModifyEventInfoResponse, err error) {
	response = CreateModifyEventInfoResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyEventInfoWithChan invokes the rds.ModifyEventInfo API asynchronously
func (client *Client) ModifyEventInfoWithChan(request *ModifyEventInfoRequest) (<-chan *ModifyEventInfoResponse, <-chan error) {
	responseChan := make(chan *ModifyEventInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyEventInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyEventInfoWithCallback invokes the rds.ModifyEventInfo API asynchronously
func (client *Client) ModifyEventInfoWithCallback(request *ModifyEventInfoRequest, callback func(response *ModifyEventInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyEventInfoResponse
		var err error
		defer close(result)
		response, err = client.ModifyEventInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyEventInfoRequest is the request struct for api ModifyEventInfo
type ModifyEventInfoRequest struct {
	*requests.RpcRequest
	EventId       string `position:"Query" name:"EventId"`
	EventAction   string `position:"Query" name:"EventAction"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
	ActionParams  string `position:"Query" name:"ActionParams"`
}

// ModifyEventInfoResponse is the response struct for api ModifyEventInfo
type ModifyEventInfoResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ErrorEventId   string `json:"ErrorEventId" xml:"ErrorEventId"`
	SuccessCount   int    `json:"SuccessCount" xml:"SuccessCount"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	SuccessEventId string `json:"SuccessEventId" xml:"SuccessEventId"`
}

// CreateModifyEventInfoRequest creates a request to invoke ModifyEventInfo API
func CreateModifyEventInfoRequest() (request *ModifyEventInfoRequest) {
	request = &ModifyEventInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "ModifyEventInfo", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyEventInfoResponse creates a response to parse from ModifyEventInfo response
func CreateModifyEventInfoResponse() (response *ModifyEventInfoResponse) {
	response = &ModifyEventInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
