package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateMaskingRules invokes the rds.CreateMaskingRules API synchronously
func (client *Client) CreateMaskingRules(request *CreateMaskingRulesRequest) (response *CreateMaskingRulesResponse, err error) {
	response = CreateCreateMaskingRulesResponse()
	err = client.DoAction(request, response)
	return
}

// CreateMaskingRulesWithChan invokes the rds.CreateMaskingRules API asynchronously
func (client *Client) CreateMaskingRulesWithChan(request *CreateMaskingRulesRequest) (<-chan *CreateMaskingRulesResponse, <-chan error) {
	responseChan := make(chan *CreateMaskingRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateMaskingRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateMaskingRulesWithCallback invokes the rds.CreateMaskingRules API asynchronously
func (client *Client) CreateMaskingRulesWithCallback(request *CreateMaskingRulesRequest, callback func(response *CreateMaskingRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateMaskingRulesResponse
		var err error
		defer close(result)
		response, err = client.CreateMaskingRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateMaskingRulesRequest is the request struct for api CreateMaskingRules
type CreateMaskingRulesRequest struct {
	*requests.RpcRequest
	DBInstanceName       string                       `position:"Query" name:"DBInstanceName"`
	ResourceOwnerId      requests.Integer             `position:"Query" name:"ResourceOwnerId"`
	MaskingAlgo          string                       `position:"Query" name:"MaskingAlgo"`
	RuleName             string                       `position:"Query" name:"RuleName"`
	ResourceOwnerAccount string                       `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              string                       `position:"Query" name:"OwnerId"`
	DefaultAlgo          string                       `position:"Query" name:"DefaultAlgo"`
	RuleConfig           CreateMaskingRulesRuleConfig `position:"Query" name:"RuleConfig"  type:"Struct"`
}

// CreateMaskingRulesRuleConfig is a repeated param struct in CreateMaskingRulesRequest
type CreateMaskingRulesRuleConfig struct {
	Databases *[]string `name:"Databases" type:"Repeated"`
	Tables    *[]string `name:"Tables" type:"Repeated"`
	Columns   *[]string `name:"Columns" type:"Repeated"`
}

// CreateMaskingRulesResponse is the response struct for api CreateMaskingRules
type CreateMaskingRulesResponse struct {
	*responses.BaseResponse
	RequestId string                 `json:"RequestId" xml:"RequestId"`
	Success   string                 `json:"Success" xml:"Success"`
	Message   string                 `json:"Message" xml:"Message"`
	Data      map[string]interface{} `json:"Data" xml:"Data"`
}

// CreateCreateMaskingRulesRequest creates a request to invoke CreateMaskingRules API
func CreateCreateMaskingRulesRequest() (request *CreateMaskingRulesRequest) {
	request = &CreateMaskingRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "CreateMaskingRules", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateMaskingRulesResponse creates a response to parse from CreateMaskingRules response
func CreateCreateMaskingRulesResponse() (response *CreateMaskingRulesResponse) {
	response = &CreateMaskingRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
