package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetDataLevelPermissionWhiteList invokes the quickbi_public.SetDataLevelPermissionWhiteList API synchronously
func (client *Client) SetDataLevelPermissionWhiteList(request *SetDataLevelPermissionWhiteListRequest) (response *SetDataLevelPermissionWhiteListResponse, err error) {
	response = CreateSetDataLevelPermissionWhiteListResponse()
	err = client.DoAction(request, response)
	return
}

// SetDataLevelPermissionWhiteListWithChan invokes the quickbi_public.SetDataLevelPermissionWhiteList API asynchronously
func (client *Client) SetDataLevelPermissionWhiteListWithChan(request *SetDataLevelPermissionWhiteListRequest) (<-chan *SetDataLevelPermissionWhiteListResponse, <-chan error) {
	responseChan := make(chan *SetDataLevelPermissionWhiteListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetDataLevelPermissionWhiteList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetDataLevelPermissionWhiteListWithCallback invokes the quickbi_public.SetDataLevelPermissionWhiteList API asynchronously
func (client *Client) SetDataLevelPermissionWhiteListWithCallback(request *SetDataLevelPermissionWhiteListRequest, callback func(response *SetDataLevelPermissionWhiteListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetDataLevelPermissionWhiteListResponse
		var err error
		defer close(result)
		response, err = client.SetDataLevelPermissionWhiteList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetDataLevelPermissionWhiteListRequest is the request struct for api SetDataLevelPermissionWhiteList
type SetDataLevelPermissionWhiteListRequest struct {
	*requests.RpcRequest
	AccessPoint    string `position:"Query" name:"AccessPoint"`
	SignType       string `position:"Query" name:"SignType"`
	WhiteListModel string `position:"Query" name:"WhiteListModel"`
}

// SetDataLevelPermissionWhiteListResponse is the response struct for api SetDataLevelPermissionWhiteList
type SetDataLevelPermissionWhiteListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    bool   `json:"Result" xml:"Result"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateSetDataLevelPermissionWhiteListRequest creates a request to invoke SetDataLevelPermissionWhiteList API
func CreateSetDataLevelPermissionWhiteListRequest() (request *SetDataLevelPermissionWhiteListRequest) {
	request = &SetDataLevelPermissionWhiteListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2022-01-01", "SetDataLevelPermissionWhiteList", "2.2.0", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetDataLevelPermissionWhiteListResponse creates a response to parse from SetDataLevelPermissionWhiteList response
func CreateSetDataLevelPermissionWhiteListResponse() (response *SetDataLevelPermissionWhiteListResponse) {
	response = &SetDataLevelPermissionWhiteListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
