package qianzhou

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListClusterImages invokes the qianzhou.ListClusterImages API synchronously
func (client *Client) ListClusterImages(request *ListClusterImagesRequest) (response *ListClusterImagesResponse, err error) {
	response = CreateListClusterImagesResponse()
	err = client.DoAction(request, response)
	return
}

// ListClusterImagesWithChan invokes the qianzhou.ListClusterImages API asynchronously
func (client *Client) ListClusterImagesWithChan(request *ListClusterImagesRequest) (<-chan *ListClusterImagesResponse, <-chan error) {
	responseChan := make(chan *ListClusterImagesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListClusterImages(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListClusterImagesWithCallback invokes the qianzhou.ListClusterImages API asynchronously
func (client *Client) ListClusterImagesWithCallback(request *ListClusterImagesRequest, callback func(response *ListClusterImagesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListClusterImagesResponse
		var err error
		defer close(result)
		response, err = client.ListClusterImages(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListClusterImagesRequest is the request struct for api ListClusterImages
type ListClusterImagesRequest struct {
	*requests.RoaRequest
	ImageName string           `position:"Query" name:"image_name"`
	Uid       string           `position:"Query" name:"uid"`
	ClusterId string           `position:"Query" name:"cluster_id"`
	ImageHash string           `position:"Query" name:"image_hash"`
	PageNo    requests.Integer `position:"Query" name:"page_no"`
	PageSize  requests.Integer `position:"Query" name:"page_size"`
}

// ListClusterImagesResponse is the response struct for api ListClusterImages
type ListClusterImagesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
	Code      int    `json:"code" xml:"code"`
	Msg       string `json:"msg" xml:"msg"`
	Datas     Datas  `json:"datas" xml:"datas"`
}

// CreateListClusterImagesRequest creates a request to invoke ListClusterImages API
func CreateListClusterImagesRequest() (request *ListClusterImagesRequest) {
	request = &ListClusterImagesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("qianzhou", "2021-11-11", "ListClusterImages", "/popapi/listClusterPodImages", "", "")
	request.Method = requests.POST
	return
}

// CreateListClusterImagesResponse creates a response to parse from ListClusterImages response
func CreateListClusterImagesResponse() (response *ListClusterImagesResponse) {
	response = &ListClusterImagesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
