package polardbx

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDBInstanceViaEndpoint invokes the polardbx.DescribeDBInstanceViaEndpoint API synchronously
func (client *Client) DescribeDBInstanceViaEndpoint(request *DescribeDBInstanceViaEndpointRequest) (response *DescribeDBInstanceViaEndpointResponse, err error) {
	response = CreateDescribeDBInstanceViaEndpointResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDBInstanceViaEndpointWithChan invokes the polardbx.DescribeDBInstanceViaEndpoint API asynchronously
func (client *Client) DescribeDBInstanceViaEndpointWithChan(request *DescribeDBInstanceViaEndpointRequest) (<-chan *DescribeDBInstanceViaEndpointResponse, <-chan error) {
	responseChan := make(chan *DescribeDBInstanceViaEndpointResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDBInstanceViaEndpoint(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDBInstanceViaEndpointWithCallback invokes the polardbx.DescribeDBInstanceViaEndpoint API asynchronously
func (client *Client) DescribeDBInstanceViaEndpointWithCallback(request *DescribeDBInstanceViaEndpointRequest, callback func(response *DescribeDBInstanceViaEndpointResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDBInstanceViaEndpointResponse
		var err error
		defer close(result)
		response, err = client.DescribeDBInstanceViaEndpoint(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDBInstanceViaEndpointRequest is the request struct for api DescribeDBInstanceViaEndpoint
type DescribeDBInstanceViaEndpointRequest struct {
	*requests.RpcRequest
	Endpoint string `position:"Query" name:"Endpoint"`
}

// DescribeDBInstanceViaEndpointResponse is the response struct for api DescribeDBInstanceViaEndpoint
type DescribeDBInstanceViaEndpointResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	DBInstance DBInstance `json:"DBInstance" xml:"DBInstance"`
}

// CreateDescribeDBInstanceViaEndpointRequest creates a request to invoke DescribeDBInstanceViaEndpoint API
func CreateDescribeDBInstanceViaEndpointRequest() (request *DescribeDBInstanceViaEndpointRequest) {
	request = &DescribeDBInstanceViaEndpointRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardbx", "2020-02-02", "DescribeDBInstanceViaEndpoint", "polardbx", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDBInstanceViaEndpointResponse creates a response to parse from DescribeDBInstanceViaEndpoint response
func CreateDescribeDBInstanceViaEndpointResponse() (response *DescribeDBInstanceViaEndpointResponse) {
	response = &DescribeDBInstanceViaEndpointResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
