package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableDBClusterServerless invokes the polardb.EnableDBClusterServerless API synchronously
func (client *Client) EnableDBClusterServerless(request *EnableDBClusterServerlessRequest) (response *EnableDBClusterServerlessResponse, err error) {
	response = CreateEnableDBClusterServerlessResponse()
	err = client.DoAction(request, response)
	return
}

// EnableDBClusterServerlessWithChan invokes the polardb.EnableDBClusterServerless API asynchronously
func (client *Client) EnableDBClusterServerlessWithChan(request *EnableDBClusterServerlessRequest) (<-chan *EnableDBClusterServerlessResponse, <-chan error) {
	responseChan := make(chan *EnableDBClusterServerlessResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableDBClusterServerless(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableDBClusterServerlessWithCallback invokes the polardb.EnableDBClusterServerless API asynchronously
func (client *Client) EnableDBClusterServerlessWithCallback(request *EnableDBClusterServerlessRequest, callback func(response *EnableDBClusterServerlessResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableDBClusterServerlessResponse
		var err error
		defer close(result)
		response, err = client.EnableDBClusterServerless(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableDBClusterServerlessRequest is the request struct for api EnableDBClusterServerless
type EnableDBClusterServerlessRequest struct {
	*requests.RpcRequest
	ScaleRoNumMax        string           `position:"Query" name:"ScaleRoNumMax"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ScaleApRoNumMax      string           `position:"Query" name:"ScaleApRoNumMax"`
	ScaleMax             string           `position:"Query" name:"ScaleMax"`
	ScaleApRoNumMin      string           `position:"Query" name:"ScaleApRoNumMin"`
	ScaleMin             string           `position:"Query" name:"ScaleMin"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ScaleRoNumMin        string           `position:"Query" name:"ScaleRoNumMin"`
}

// EnableDBClusterServerlessResponse is the response struct for api EnableDBClusterServerless
type EnableDBClusterServerlessResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	DBClusterId string `json:"DBClusterId" xml:"DBClusterId"`
}

// CreateEnableDBClusterServerlessRequest creates a request to invoke EnableDBClusterServerless API
func CreateEnableDBClusterServerlessRequest() (request *EnableDBClusterServerlessRequest) {
	request = &EnableDBClusterServerlessRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "EnableDBClusterServerless", "polardb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEnableDBClusterServerlessResponse creates a response to parse from EnableDBClusterServerless response
func CreateEnableDBClusterServerlessResponse() (response *EnableDBClusterServerlessResponse) {
	response = &EnableDBClusterServerlessResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
