package nas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableRecycleBin invokes the nas.EnableRecycleBin API synchronously
func (client *Client) EnableRecycleBin(request *EnableRecycleBinRequest) (response *EnableRecycleBinResponse, err error) {
	response = CreateEnableRecycleBinResponse()
	err = client.DoAction(request, response)
	return
}

// EnableRecycleBinWithChan invokes the nas.EnableRecycleBin API asynchronously
func (client *Client) EnableRecycleBinWithChan(request *EnableRecycleBinRequest) (<-chan *EnableRecycleBinResponse, <-chan error) {
	responseChan := make(chan *EnableRecycleBinResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableRecycleBin(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableRecycleBinWithCallback invokes the nas.EnableRecycleBin API asynchronously
func (client *Client) EnableRecycleBinWithCallback(request *EnableRecycleBinRequest, callback func(response *EnableRecycleBinResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableRecycleBinResponse
		var err error
		defer close(result)
		response, err = client.EnableRecycleBin(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableRecycleBinRequest is the request struct for api EnableRecycleBin
type EnableRecycleBinRequest struct {
	*requests.RpcRequest
	FileSystemId string           `position:"Query" name:"FileSystemId"`
	ReservedDays requests.Integer `position:"Query" name:"ReservedDays"`
}

// EnableRecycleBinResponse is the response struct for api EnableRecycleBin
type EnableRecycleBinResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateEnableRecycleBinRequest creates a request to invoke EnableRecycleBin API
func CreateEnableRecycleBinRequest() (request *EnableRecycleBinRequest) {
	request = &EnableRecycleBinRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("NAS", "2017-06-26", "EnableRecycleBin", "nas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEnableRecycleBinResponse creates a response to parse from EnableRecycleBin response
func CreateEnableRecycleBinResponse() (response *EnableRecycleBinResponse) {
	response = &EnableRecycleBinResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
