package mseap

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PushRpaTask invokes the mseap.PushRpaTask API synchronously
func (client *Client) PushRpaTask(request *PushRpaTaskRequest) (response *PushRpaTaskResponse, err error) {
	response = CreatePushRpaTaskResponse()
	err = client.DoAction(request, response)
	return
}

// PushRpaTaskWithChan invokes the mseap.PushRpaTask API asynchronously
func (client *Client) PushRpaTaskWithChan(request *PushRpaTaskRequest) (<-chan *PushRpaTaskResponse, <-chan error) {
	responseChan := make(chan *PushRpaTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PushRpaTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PushRpaTaskWithCallback invokes the mseap.PushRpaTask API asynchronously
func (client *Client) PushRpaTaskWithCallback(request *PushRpaTaskRequest, callback func(response *PushRpaTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PushRpaTaskResponse
		var err error
		defer close(result)
		response, err = client.PushRpaTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PushRpaTaskRequest is the request struct for api PushRpaTask
type PushRpaTaskRequest struct {
	*requests.RpcRequest
	Request            string           `position:"Query" name:"Request"`
	UserCallerParentId requests.Integer `position:"Query" name:"UserCallerParentId"`
	ApiType            string           `position:"Query" name:"ApiType"`
	UserMfaPresent     requests.Boolean `position:"Query" name:"UserMfaPresent"`
	UserKp             string           `position:"Query" name:"UserKp"`
	Lang               string           `position:"Query" name:"Lang"`
	TaskId             requests.Integer `position:"Query" name:"TaskId"`
	UserCallerType     string           `position:"Query" name:"UserCallerType"`
	UserSecurityToken  string           `position:"Query" name:"UserSecurityToken"`
	UserAccessKeyId    string           `position:"Query" name:"UserAccessKeyId"`
	ModelId            requests.Integer `position:"Query" name:"ModelId"`
	AliyunKp           string           `position:"Query" name:"AliyunKp"`
	UserBid            string           `position:"Query" name:"UserBid"`
	OriginalRequest    string           `position:"Query" name:"OriginalRequest"`
	TemplateId         requests.Integer `position:"Query" name:"TemplateId"`
	UserClientIp       string           `position:"Query" name:"UserClientIp"`
	Name               string           `position:"Query" name:"Name"`
	Bid                string           `position:"Query" name:"Bid"`
	Status             requests.Integer `position:"Query" name:"Status"`
}

// PushRpaTaskResponse is the response struct for api PushRpaTask
type PushRpaTaskResponse struct {
	*responses.BaseResponse
	AllowRetry     bool   `json:"AllowRetry" xml:"AllowRetry"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ErrorMsg       string `json:"ErrorMsg" xml:"ErrorMsg"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	Module         string `json:"Module" xml:"Module"`
	Success        bool   `json:"Success" xml:"Success"`
	AppName        string `json:"AppName" xml:"AppName"`
}

// CreatePushRpaTaskRequest creates a request to invoke PushRpaTask API
func CreatePushRpaTaskRequest() (request *PushRpaTaskRequest) {
	request = &PushRpaTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mseap", "2021-01-18", "PushRpaTask", "", "")
	request.Method = requests.POST
	return
}

// CreatePushRpaTaskResponse creates a response to parse from PushRpaTask response
func CreatePushRpaTaskResponse() (response *PushRpaTaskResponse) {
	response = &PushRpaTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
