package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListExportZookeeperData invokes the mse.ListExportZookeeperData API synchronously
func (client *Client) ListExportZookeeperData(request *ListExportZookeeperDataRequest) (response *ListExportZookeeperDataResponse, err error) {
	response = CreateListExportZookeeperDataResponse()
	err = client.DoAction(request, response)
	return
}

// ListExportZookeeperDataWithChan invokes the mse.ListExportZookeeperData API asynchronously
func (client *Client) ListExportZookeeperDataWithChan(request *ListExportZookeeperDataRequest) (<-chan *ListExportZookeeperDataResponse, <-chan error) {
	responseChan := make(chan *ListExportZookeeperDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListExportZookeeperData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListExportZookeeperDataWithCallback invokes the mse.ListExportZookeeperData API asynchronously
func (client *Client) ListExportZookeeperDataWithCallback(request *ListExportZookeeperDataRequest, callback func(response *ListExportZookeeperDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListExportZookeeperDataResponse
		var err error
		defer close(result)
		response, err = client.ListExportZookeeperData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListExportZookeeperDataRequest is the request struct for api ListExportZookeeperData
type ListExportZookeeperDataRequest struct {
	*requests.RpcRequest
	MseSessionId   string           `position:"Query" name:"MseSessionId"`
	PageNumber     requests.Integer `position:"Query" name:"PageNumber"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	InstanceId     string           `position:"Query" name:"InstanceId"`
	AcceptLanguage string           `position:"Query" name:"AcceptLanguage"`
}

// ListExportZookeeperDataResponse is the response struct for api ListExportZookeeperData
type ListExportZookeeperDataResponse struct {
	*responses.BaseResponse
	Success        bool                                `json:"Success" xml:"Success"`
	Message        string                              `json:"Message" xml:"Message"`
	DynamicMessage string                              `json:"DynamicMessage" xml:"DynamicMessage"`
	RequestId      string                              `json:"RequestId" xml:"RequestId"`
	ErrorCode      string                              `json:"ErrorCode" xml:"ErrorCode"`
	HttpStatusCode string                              `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           []DataItemInListExportZookeeperData `json:"Data" xml:"Data"`
}

// CreateListExportZookeeperDataRequest creates a request to invoke ListExportZookeeperData API
func CreateListExportZookeeperDataRequest() (request *ListExportZookeeperDataRequest) {
	request = &ListExportZookeeperDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "ListExportZookeeperData", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListExportZookeeperDataResponse creates a response to parse from ListExportZookeeperData response
func CreateListExportZookeeperDataResponse() (response *ListExportZookeeperDataResponse) {
	response = &ListExportZookeeperDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
