package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateMcubeMiniTask invokes the mpaas.CreateMcubeMiniTask API synchronously
func (client *Client) CreateMcubeMiniTask(request *CreateMcubeMiniTaskRequest) (response *CreateMcubeMiniTaskResponse, err error) {
	response = CreateCreateMcubeMiniTaskResponse()
	err = client.DoAction(request, response)
	return
}

// CreateMcubeMiniTaskWithChan invokes the mpaas.CreateMcubeMiniTask API asynchronously
func (client *Client) CreateMcubeMiniTaskWithChan(request *CreateMcubeMiniTaskRequest) (<-chan *CreateMcubeMiniTaskResponse, <-chan error) {
	responseChan := make(chan *CreateMcubeMiniTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateMcubeMiniTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateMcubeMiniTaskWithCallback invokes the mpaas.CreateMcubeMiniTask API asynchronously
func (client *Client) CreateMcubeMiniTaskWithCallback(request *CreateMcubeMiniTaskRequest, callback func(response *CreateMcubeMiniTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateMcubeMiniTaskResponse
		var err error
		defer close(result)
		response, err = client.CreateMcubeMiniTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateMcubeMiniTaskRequest is the request struct for api CreateMcubeMiniTask
type CreateMcubeMiniTaskRequest struct {
	*requests.RpcRequest
	PackageId       requests.Integer `position:"Body" name:"PackageId"`
	Memo            string           `position:"Body" name:"Memo"`
	GreyConfigInfo  string           `position:"Body" name:"GreyConfigInfo"`
	TenantId        string           `position:"Body" name:"TenantId"`
	PublishMode     requests.Integer `position:"Body" name:"PublishMode"`
	WhitelistIds    string           `position:"Body" name:"WhitelistIds"`
	PublishType     requests.Integer `position:"Body" name:"PublishType"`
	GreyNum         requests.Integer `position:"Body" name:"GreyNum"`
	AppId           string           `position:"Body" name:"AppId"`
	GreyEndtimeData string           `position:"Body" name:"GreyEndtimeData"`
	WorkspaceId     string           `position:"Body" name:"WorkspaceId"`
}

// CreateMcubeMiniTaskResponse is the response struct for api CreateMcubeMiniTask
type CreateMcubeMiniTaskResponse struct {
	*responses.BaseResponse
	ResultMessage        string               `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode           string               `json:"ResultCode" xml:"ResultCode"`
	RequestId            string               `json:"RequestId" xml:"RequestId"`
	CreateMiniTaskResult CreateMiniTaskResult `json:"CreateMiniTaskResult" xml:"CreateMiniTaskResult"`
}

// CreateCreateMcubeMiniTaskRequest creates a request to invoke CreateMcubeMiniTask API
func CreateCreateMcubeMiniTaskRequest() (request *CreateMcubeMiniTaskRequest) {
	request = &CreateMcubeMiniTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "CreateMcubeMiniTask", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateMcubeMiniTaskResponse creates a response to parse from CreateMcubeMiniTask response
func CreateCreateMcubeMiniTaskResponse() (response *CreateMcubeMiniTaskResponse) {
	response = &CreateMcubeMiniTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
