package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AsyncScanAppMPCD invokes the mpaas.AsyncScanAppMPCD API synchronously
func (client *Client) AsyncScanAppMPCD(request *AsyncScanAppMPCDRequest) (response *AsyncScanAppMPCDResponse, err error) {
	response = CreateAsyncScanAppMPCDResponse()
	err = client.DoAction(request, response)
	return
}

// AsyncScanAppMPCDWithChan invokes the mpaas.AsyncScanAppMPCD API asynchronously
func (client *Client) AsyncScanAppMPCDWithChan(request *AsyncScanAppMPCDRequest) (<-chan *AsyncScanAppMPCDResponse, <-chan error) {
	responseChan := make(chan *AsyncScanAppMPCDResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AsyncScanAppMPCD(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AsyncScanAppMPCDWithCallback invokes the mpaas.AsyncScanAppMPCD API asynchronously
func (client *Client) AsyncScanAppMPCDWithCallback(request *AsyncScanAppMPCDRequest, callback func(response *AsyncScanAppMPCDResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AsyncScanAppMPCDResponse
		var err error
		defer close(result)
		response, err = client.AsyncScanAppMPCD(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AsyncScanAppMPCDRequest is the request struct for api AsyncScanAppMPCD
type AsyncScanAppMPCDRequest struct {
	*requests.RpcRequest
	AppId       string           `position:"Body" name:"AppId"`
	TenantId    string           `position:"Body" name:"TenantId"`
	ScanTaskId  requests.Integer `position:"Body" name:"ScanTaskId"`
	WorkspaceId string           `position:"Body" name:"WorkspaceId"`
}

// AsyncScanAppMPCDResponse is the response struct for api AsyncScanAppMPCD
type AsyncScanAppMPCDResponse struct {
	*responses.BaseResponse
}

// CreateAsyncScanAppMPCDRequest creates a request to invoke AsyncScanAppMPCD API
func CreateAsyncScanAppMPCDRequest() (request *AsyncScanAppMPCDRequest) {
	request = &AsyncScanAppMPCDRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "AsyncScanAppMPCD", "", "")
	request.Method = requests.POST
	return
}

// CreateAsyncScanAppMPCDResponse creates a response to parse from AsyncScanAppMPCD response
func CreateAsyncScanAppMPCDResponse() (response *AsyncScanAppMPCDResponse) {
	response = &AsyncScanAppMPCDResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
