package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListRouteRule invokes the lto.ListRouteRule API synchronously
func (client *Client) ListRouteRule(request *ListRouteRuleRequest) (response *ListRouteRuleResponse, err error) {
	response = CreateListRouteRuleResponse()
	err = client.DoAction(request, response)
	return
}

// ListRouteRuleWithChan invokes the lto.ListRouteRule API asynchronously
func (client *Client) ListRouteRuleWithChan(request *ListRouteRuleRequest) (<-chan *ListRouteRuleResponse, <-chan error) {
	responseChan := make(chan *ListRouteRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListRouteRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListRouteRuleWithCallback invokes the lto.ListRouteRule API asynchronously
func (client *Client) ListRouteRuleWithCallback(request *ListRouteRuleRequest, callback func(response *ListRouteRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListRouteRuleResponse
		var err error
		defer close(result)
		response, err = client.ListRouteRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListRouteRuleRequest is the request struct for api ListRouteRule
type ListRouteRuleRequest struct {
	*requests.RpcRequest
	Num             requests.Integer `position:"Query" name:"Num"`
	BizChainName    string           `position:"Query" name:"BizChainName"`
	Size            requests.Integer `position:"Query" name:"Size"`
	DeviceGroupName string           `position:"Query" name:"DeviceGroupName"`
	ChainUpMode     string           `position:"Query" name:"ChainUpMode"`
}

// ListRouteRuleResponse is the response struct for api ListRouteRule
type ListRouteRuleResponse struct {
	*responses.BaseResponse
	Code           string              `json:"Code" xml:"Code"`
	HttpStatusCode int                 `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string              `json:"Message" xml:"Message"`
	RequestId      string              `json:"RequestId" xml:"RequestId"`
	Success        bool                `json:"Success" xml:"Success"`
	Data           DataInListRouteRule `json:"Data" xml:"Data"`
}

// CreateListRouteRuleRequest creates a request to invoke ListRouteRule API
func CreateListRouteRuleRequest() (request *ListRouteRuleRequest) {
	request = &ListRouteRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "ListRouteRule", "", "")
	request.Method = requests.POST
	return
}

// CreateListRouteRuleResponse creates a response to parse from ListRouteRule response
func CreateListRouteRuleResponse() (response *ListRouteRuleResponse) {
	response = &ListRouteRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
