package ltl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchUploadMPCoSPhaseTextInfo invokes the ltl.BatchUploadMPCoSPhaseTextInfo API synchronously
func (client *Client) BatchUploadMPCoSPhaseTextInfo(request *BatchUploadMPCoSPhaseTextInfoRequest) (response *BatchUploadMPCoSPhaseTextInfoResponse, err error) {
	response = CreateBatchUploadMPCoSPhaseTextInfoResponse()
	err = client.DoAction(request, response)
	return
}

// BatchUploadMPCoSPhaseTextInfoWithChan invokes the ltl.BatchUploadMPCoSPhaseTextInfo API asynchronously
func (client *Client) BatchUploadMPCoSPhaseTextInfoWithChan(request *BatchUploadMPCoSPhaseTextInfoRequest) (<-chan *BatchUploadMPCoSPhaseTextInfoResponse, <-chan error) {
	responseChan := make(chan *BatchUploadMPCoSPhaseTextInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchUploadMPCoSPhaseTextInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchUploadMPCoSPhaseTextInfoWithCallback invokes the ltl.BatchUploadMPCoSPhaseTextInfo API asynchronously
func (client *Client) BatchUploadMPCoSPhaseTextInfoWithCallback(request *BatchUploadMPCoSPhaseTextInfoRequest, callback func(response *BatchUploadMPCoSPhaseTextInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchUploadMPCoSPhaseTextInfoResponse
		var err error
		defer close(result)
		response, err = client.BatchUploadMPCoSPhaseTextInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchUploadMPCoSPhaseTextInfoRequest is the request struct for api BatchUploadMPCoSPhaseTextInfo
type BatchUploadMPCoSPhaseTextInfoRequest struct {
	*requests.RpcRequest
	PhaseDataList map[string]interface{} `position:"Query" name:"PhaseDataList"`
	PhaseId       string                 `position:"Query" name:"PhaseId"`
	PhaseGroupId  string                 `position:"Query" name:"PhaseGroupId"`
	ApiVersion    string                 `position:"Query" name:"ApiVersion"`
	BizChainId    string                 `position:"Query" name:"BizChainId"`
}

// BatchUploadMPCoSPhaseTextInfoResponse is the response struct for api BatchUploadMPCoSPhaseTextInfo
type BatchUploadMPCoSPhaseTextInfoResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateBatchUploadMPCoSPhaseTextInfoRequest creates a request to invoke BatchUploadMPCoSPhaseTextInfo API
func CreateBatchUploadMPCoSPhaseTextInfoRequest() (request *BatchUploadMPCoSPhaseTextInfoRequest) {
	request = &BatchUploadMPCoSPhaseTextInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ltl", "2019-05-10", "BatchUploadMPCoSPhaseTextInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateBatchUploadMPCoSPhaseTextInfoResponse creates a response to parse from BatchUploadMPCoSPhaseTextInfo response
func CreateBatchUploadMPCoSPhaseTextInfoResponse() (response *BatchUploadMPCoSPhaseTextInfoResponse) {
	response = &BatchUploadMPCoSPhaseTextInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
