package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteMessageApp invokes the live.DeleteMessageApp API synchronously
func (client *Client) DeleteMessageApp(request *DeleteMessageAppRequest) (response *DeleteMessageAppResponse, err error) {
	response = CreateDeleteMessageAppResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteMessageAppWithChan invokes the live.DeleteMessageApp API asynchronously
func (client *Client) DeleteMessageAppWithChan(request *DeleteMessageAppRequest) (<-chan *DeleteMessageAppResponse, <-chan error) {
	responseChan := make(chan *DeleteMessageAppResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteMessageApp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteMessageAppWithCallback invokes the live.DeleteMessageApp API asynchronously
func (client *Client) DeleteMessageAppWithCallback(request *DeleteMessageAppRequest, callback func(response *DeleteMessageAppResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteMessageAppResponse
		var err error
		defer close(result)
		response, err = client.DeleteMessageApp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteMessageAppRequest is the request struct for api DeleteMessageApp
type DeleteMessageAppRequest struct {
	*requests.RpcRequest
	AppId string `position:"Body" name:"AppId"`
}

// DeleteMessageAppResponse is the response struct for api DeleteMessageApp
type DeleteMessageAppResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDeleteMessageAppRequest creates a request to invoke DeleteMessageApp API
func CreateDeleteMessageAppRequest() (request *DeleteMessageAppRequest) {
	request = &DeleteMessageAppRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DeleteMessageApp", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteMessageAppResponse creates a response to parse from DeleteMessageApp response
func CreateDeleteMessageAppResponse() (response *DeleteMessageAppResponse) {
	response = &DeleteMessageAppResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
