package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySoundCodeLabelList invokes the iot.QuerySoundCodeLabelList API synchronously
func (client *Client) QuerySoundCodeLabelList(request *QuerySoundCodeLabelListRequest) (response *QuerySoundCodeLabelListResponse, err error) {
	response = CreateQuerySoundCodeLabelListResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySoundCodeLabelListWithChan invokes the iot.QuerySoundCodeLabelList API asynchronously
func (client *Client) QuerySoundCodeLabelListWithChan(request *QuerySoundCodeLabelListRequest) (<-chan *QuerySoundCodeLabelListResponse, <-chan error) {
	responseChan := make(chan *QuerySoundCodeLabelListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySoundCodeLabelList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySoundCodeLabelListWithCallback invokes the iot.QuerySoundCodeLabelList API asynchronously
func (client *Client) QuerySoundCodeLabelListWithCallback(request *QuerySoundCodeLabelListRequest, callback func(response *QuerySoundCodeLabelListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySoundCodeLabelListResponse
		var err error
		defer close(result)
		response, err = client.QuerySoundCodeLabelList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySoundCodeLabelListRequest is the request struct for api QuerySoundCodeLabelList
type QuerySoundCodeLabelListRequest struct {
	*requests.RpcRequest
	ScheduleCode  string           `position:"Body" name:"ScheduleCode"`
	PageId        requests.Integer `position:"Body" name:"PageId"`
	IotInstanceId string           `position:"Body" name:"IotInstanceId"`
	PageSize      requests.Integer `position:"Body" name:"PageSize"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
}

// QuerySoundCodeLabelListResponse is the response struct for api QuerySoundCodeLabelList
type QuerySoundCodeLabelListResponse struct {
	*responses.BaseResponse
	RequestId    string                        `json:"RequestId" xml:"RequestId"`
	Success      bool                          `json:"Success" xml:"Success"`
	Code         string                        `json:"Code" xml:"Code"`
	ErrorMessage string                        `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         DataInQuerySoundCodeLabelList `json:"Data" xml:"Data"`
}

// CreateQuerySoundCodeLabelListRequest creates a request to invoke QuerySoundCodeLabelList API
func CreateQuerySoundCodeLabelListRequest() (request *QuerySoundCodeLabelListRequest) {
	request = &QuerySoundCodeLabelListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "QuerySoundCodeLabelList", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQuerySoundCodeLabelListResponse creates a response to parse from QuerySoundCodeLabelList response
func CreateQuerySoundCodeLabelListResponse() (response *QuerySoundCodeLabelListResponse) {
	response = &QuerySoundCodeLabelListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
