package idaas_doraemon

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// FetchAccessToken invokes the idaas_doraemon.FetchAccessToken API synchronously
func (client *Client) FetchAccessToken(request *FetchAccessTokenRequest) (response *FetchAccessTokenResponse, err error) {
	response = CreateFetchAccessTokenResponse()
	err = client.DoAction(request, response)
	return
}

// FetchAccessTokenWithChan invokes the idaas_doraemon.FetchAccessToken API asynchronously
func (client *Client) FetchAccessTokenWithChan(request *FetchAccessTokenRequest) (<-chan *FetchAccessTokenResponse, <-chan error) {
	responseChan := make(chan *FetchAccessTokenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.FetchAccessToken(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// FetchAccessTokenWithCallback invokes the idaas_doraemon.FetchAccessToken API asynchronously
func (client *Client) FetchAccessTokenWithCallback(request *FetchAccessTokenRequest, callback func(response *FetchAccessTokenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *FetchAccessTokenResponse
		var err error
		defer close(result)
		response, err = client.FetchAccessToken(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// FetchAccessTokenRequest is the request struct for api FetchAccessToken
type FetchAccessTokenRequest struct {
	*requests.RpcRequest
	UserId                     string `position:"Query" name:"UserId"`
	XClientIp                  string `position:"Query" name:"XClientIp"`
	MobileExtendParamsJsonSign string `position:"Query" name:"MobileExtendParamsJsonSign"`
	ServerExtendParamsJson     string `position:"Query" name:"ServerExtendParamsJson"`
	MobileExtendParamsJson     string `position:"Query" name:"MobileExtendParamsJson"`
	ApplicationExternalId      string `position:"Query" name:"ApplicationExternalId"`
}

// FetchAccessTokenResponse is the response struct for api FetchAccessToken
type FetchAccessTokenResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateFetchAccessTokenRequest creates a request to invoke FetchAccessToken API
func CreateFetchAccessTokenRequest() (request *FetchAccessTokenRequest) {
	request = &FetchAccessTokenRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("idaas-doraemon", "2021-05-20", "FetchAccessToken", "idaasauth", "openAPI")
	request.Method = requests.POST
	return
}

// CreateFetchAccessTokenResponse creates a response to parse from FetchAccessToken response
func CreateFetchAccessTokenResponse() (response *FetchAccessTokenResponse) {
	response = &FetchAccessTokenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
