package gpdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateSampleData invokes the gpdb.CreateSampleData API synchronously
func (client *Client) CreateSampleData(request *CreateSampleDataRequest) (response *CreateSampleDataResponse, err error) {
	response = CreateCreateSampleDataResponse()
	err = client.DoAction(request, response)
	return
}

// CreateSampleDataWithChan invokes the gpdb.CreateSampleData API asynchronously
func (client *Client) CreateSampleDataWithChan(request *CreateSampleDataRequest) (<-chan *CreateSampleDataResponse, <-chan error) {
	responseChan := make(chan *CreateSampleDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateSampleData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateSampleDataWithCallback invokes the gpdb.CreateSampleData API asynchronously
func (client *Client) CreateSampleDataWithCallback(request *CreateSampleDataRequest, callback func(response *CreateSampleDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateSampleDataResponse
		var err error
		defer close(result)
		response, err = client.CreateSampleData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateSampleDataRequest is the request struct for api CreateSampleData
type CreateSampleDataRequest struct {
	*requests.RpcRequest
	DBInstanceId string           `position:"Query" name:"DBInstanceId"`
	OwnerId      requests.Integer `position:"Query" name:"OwnerId"`
}

// CreateSampleDataResponse is the response struct for api CreateSampleData
type CreateSampleDataResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Status       bool   `json:"Status" xml:"Status"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	DBInstanceId string `json:"DBInstanceId" xml:"DBInstanceId"`
}

// CreateCreateSampleDataRequest creates a request to invoke CreateSampleData API
func CreateCreateSampleDataRequest() (request *CreateSampleDataRequest) {
	request = &CreateSampleDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("gpdb", "2016-05-03", "CreateSampleData", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateSampleDataResponse creates a response to parse from CreateSampleData response
func CreateCreateSampleDataResponse() (response *CreateSampleDataResponse) {
	response = &CreateSampleDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
