package foas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetRawPlanJson invokes the foas.GetRawPlanJson API synchronously
func (client *Client) GetRawPlanJson(request *GetRawPlanJsonRequest) (response *GetRawPlanJsonResponse, err error) {
	response = CreateGetRawPlanJsonResponse()
	err = client.DoAction(request, response)
	return
}

// GetRawPlanJsonWithChan invokes the foas.GetRawPlanJson API asynchronously
func (client *Client) GetRawPlanJsonWithChan(request *GetRawPlanJsonRequest) (<-chan *GetRawPlanJsonResponse, <-chan error) {
	responseChan := make(chan *GetRawPlanJsonResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetRawPlanJson(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetRawPlanJsonWithCallback invokes the foas.GetRawPlanJson API asynchronously
func (client *Client) GetRawPlanJsonWithCallback(request *GetRawPlanJsonRequest, callback func(response *GetRawPlanJsonResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetRawPlanJsonResponse
		var err error
		defer close(result)
		response, err = client.GetRawPlanJson(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetRawPlanJsonRequest is the request struct for api GetRawPlanJson
type GetRawPlanJsonRequest struct {
	*requests.RoaRequest
	ProjectName    string           `position:"Path" name:"projectName"`
	ExpectedGB     requests.Float   `position:"Query" name:"expectedGB"`
	ExpectedCore   requests.Float   `position:"Query" name:"expectedCore"`
	AdvisorAction  string           `position:"Query" name:"AdvisorAction"`
	JobName        string           `position:"Path" name:"jobName"`
	AutoconfEnable requests.Boolean `position:"Query" name:"autoconfEnable"`
}

// GetRawPlanJsonResponse is the response struct for api GetRawPlanJson
type GetRawPlanJsonResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	SessionId string `json:"SessionId" xml:"SessionId"`
}

// CreateGetRawPlanJsonRequest creates a request to invoke GetRawPlanJson API
func CreateGetRawPlanJsonRequest() (request *GetRawPlanJsonRequest) {
	request = &GetRawPlanJsonRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("foas", "2018-11-11", "GetRawPlanJson", "/api/v2/projects/[projectName]/jobs/[jobName]/planjson", "foas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetRawPlanJsonResponse creates a response to parse from GetRawPlanJson response
func CreateGetRawPlanJsonResponse() (response *GetRawPlanJsonResponse) {
	response = &GetRawPlanJsonResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
