package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateKibanaPvlNetwork invokes the elasticsearch.UpdateKibanaPvlNetwork API synchronously
func (client *Client) UpdateKibanaPvlNetwork(request *UpdateKibanaPvlNetworkRequest) (response *UpdateKibanaPvlNetworkResponse, err error) {
	response = CreateUpdateKibanaPvlNetworkResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateKibanaPvlNetworkWithChan invokes the elasticsearch.UpdateKibanaPvlNetwork API asynchronously
func (client *Client) UpdateKibanaPvlNetworkWithChan(request *UpdateKibanaPvlNetworkRequest) (<-chan *UpdateKibanaPvlNetworkResponse, <-chan error) {
	responseChan := make(chan *UpdateKibanaPvlNetworkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateKibanaPvlNetwork(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateKibanaPvlNetworkWithCallback invokes the elasticsearch.UpdateKibanaPvlNetwork API asynchronously
func (client *Client) UpdateKibanaPvlNetworkWithCallback(request *UpdateKibanaPvlNetworkRequest, callback func(response *UpdateKibanaPvlNetworkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateKibanaPvlNetworkResponse
		var err error
		defer close(result)
		response, err = client.UpdateKibanaPvlNetwork(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateKibanaPvlNetworkRequest is the request struct for api UpdateKibanaPvlNetwork
type UpdateKibanaPvlNetworkRequest struct {
	*requests.RoaRequest
	PvlId      string `position:"Query" name:"pvlId"`
	InstanceId string `position:"Path" name:"InstanceId"`
	Body       string `position:"Body" name:"body"`
}

// UpdateKibanaPvlNetworkResponse is the response struct for api UpdateKibanaPvlNetwork
type UpdateKibanaPvlNetworkResponse struct {
	*responses.BaseResponse
	Result    bool   `json:"Result" xml:"Result"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateKibanaPvlNetworkRequest creates a request to invoke UpdateKibanaPvlNetwork API
func CreateUpdateKibanaPvlNetworkRequest() (request *UpdateKibanaPvlNetworkRequest) {
	request = &UpdateKibanaPvlNetworkRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "UpdateKibanaPvlNetwork", "/openapi/instances/[InstanceId]/actions/update-kibana-private", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateKibanaPvlNetworkResponse creates a response to parse from UpdateKibanaPvlNetwork response
func CreateUpdateKibanaPvlNetworkResponse() (response *UpdateKibanaPvlNetworkResponse) {
	response = &UpdateKibanaPvlNetworkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
