package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSavingsPlanEstimation invokes the ecs.DescribeSavingsPlanEstimation API synchronously
func (client *Client) DescribeSavingsPlanEstimation(request *DescribeSavingsPlanEstimationRequest) (response *DescribeSavingsPlanEstimationResponse, err error) {
	response = CreateDescribeSavingsPlanEstimationResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSavingsPlanEstimationWithChan invokes the ecs.DescribeSavingsPlanEstimation API asynchronously
func (client *Client) DescribeSavingsPlanEstimationWithChan(request *DescribeSavingsPlanEstimationRequest) (<-chan *DescribeSavingsPlanEstimationResponse, <-chan error) {
	responseChan := make(chan *DescribeSavingsPlanEstimationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSavingsPlanEstimation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSavingsPlanEstimationWithCallback invokes the ecs.DescribeSavingsPlanEstimation API asynchronously
func (client *Client) DescribeSavingsPlanEstimationWithCallback(request *DescribeSavingsPlanEstimationRequest, callback func(response *DescribeSavingsPlanEstimationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSavingsPlanEstimationResponse
		var err error
		defer close(result)
		response, err = client.DescribeSavingsPlanEstimation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSavingsPlanEstimationRequest is the request struct for api DescribeSavingsPlanEstimation
type DescribeSavingsPlanEstimationRequest struct {
	*requests.RpcRequest
	ResourceId         string `position:"Query" name:"ResourceId"`
	Period             string `position:"Query" name:"Period"`
	PlanType           string `position:"Query" name:"PlanType"`
	InstanceTypeScope  string `position:"Query" name:"InstanceTypeScope"`
	PeriodUnit         string `position:"Query" name:"PeriodUnit"`
	OfferingType       string `position:"Query" name:"OfferingType"`
	EstimationResource string `position:"Query" name:"EstimationResource"`
}

// DescribeSavingsPlanEstimationResponse is the response struct for api DescribeSavingsPlanEstimation
type DescribeSavingsPlanEstimationResponse struct {
	*responses.BaseResponse
	RequestId               string `json:"RequestId" xml:"RequestId"`
	ResourceId              string `json:"ResourceId" xml:"ResourceId"`
	InstanceTypeFamily      string `json:"InstanceTypeFamily" xml:"InstanceTypeFamily"`
	CommittedAmount         string `json:"CommittedAmount" xml:"CommittedAmount"`
	Currency                string `json:"Currency" xml:"Currency"`
	OfferingType            string `json:"OfferingType" xml:"OfferingType"`
	PeriodUnit              string `json:"PeriodUnit" xml:"PeriodUnit"`
	Period                  int    `json:"Period" xml:"Period"`
	PlanType                string `json:"PlanType" xml:"PlanType"`
	InstanceTypeFamilyGroup string `json:"InstanceTypeFamilyGroup" xml:"InstanceTypeFamilyGroup"`
}

// CreateDescribeSavingsPlanEstimationRequest creates a request to invoke DescribeSavingsPlanEstimation API
func CreateDescribeSavingsPlanEstimationRequest() (request *DescribeSavingsPlanEstimationRequest) {
	request = &DescribeSavingsPlanEstimationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "DescribeSavingsPlanEstimation", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSavingsPlanEstimationResponse creates a response to parse from DescribeSavingsPlanEstimation response
func CreateDescribeSavingsPlanEstimationResponse() (response *DescribeSavingsPlanEstimationResponse) {
	response = &DescribeSavingsPlanEstimationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
