package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateSavingsPlan invokes the ecs.CreateSavingsPlan API synchronously
func (client *Client) CreateSavingsPlan(request *CreateSavingsPlanRequest) (response *CreateSavingsPlanResponse, err error) {
	response = CreateCreateSavingsPlanResponse()
	err = client.DoAction(request, response)
	return
}

// CreateSavingsPlanWithChan invokes the ecs.CreateSavingsPlan API asynchronously
func (client *Client) CreateSavingsPlanWithChan(request *CreateSavingsPlanRequest) (<-chan *CreateSavingsPlanResponse, <-chan error) {
	responseChan := make(chan *CreateSavingsPlanResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateSavingsPlan(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateSavingsPlanWithCallback invokes the ecs.CreateSavingsPlan API asynchronously
func (client *Client) CreateSavingsPlanWithCallback(request *CreateSavingsPlanRequest, callback func(response *CreateSavingsPlanResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateSavingsPlanResponse
		var err error
		defer close(result)
		response, err = client.CreateSavingsPlan(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateSavingsPlanRequest is the request struct for api CreateSavingsPlan
type CreateSavingsPlanRequest struct {
	*requests.RpcRequest
	InstanceTypeFamilyGroup string    `position:"Query" name:"InstanceTypeFamilyGroup"`
	PlanType                string    `position:"Query" name:"PlanType"`
	CommittedAmount         string    `position:"Query" name:"CommittedAmount"`
	Period                  string    `position:"Query" name:"Period"`
	ResourceId              *[]string `position:"Query" name:"ResourceId"  type:"Repeated"`
	InstanceTypeFamily      string    `position:"Query" name:"InstanceTypeFamily"`
	PeriodUnit              string    `position:"Query" name:"PeriodUnit"`
	OfferingType            string    `position:"Query" name:"OfferingType"`
	ChargeType              string    `position:"Query" name:"ChargeType"`
}

// CreateSavingsPlanResponse is the response struct for api CreateSavingsPlan
type CreateSavingsPlanResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	SavingsPlanId string `json:"SavingsPlanId" xml:"SavingsPlanId"`
	OrderId       string `json:"OrderId" xml:"OrderId"`
}

// CreateCreateSavingsPlanRequest creates a request to invoke CreateSavingsPlan API
func CreateCreateSavingsPlanRequest() (request *CreateSavingsPlanRequest) {
	request = &CreateSavingsPlanRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "CreateSavingsPlan", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateSavingsPlanResponse creates a response to parse from CreateSavingsPlan response
func CreateCreateSavingsPlanResponse() (response *CreateSavingsPlanResponse) {
	response = &CreateSavingsPlanResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
