package ecs_workbench

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// LoginInstance invokes the ecs_workbench.LoginInstance API synchronously
func (client *Client) LoginInstance(request *LoginInstanceRequest) (response *LoginInstanceResponse, err error) {
	response = CreateLoginInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// LoginInstanceWithChan invokes the ecs_workbench.LoginInstance API asynchronously
func (client *Client) LoginInstanceWithChan(request *LoginInstanceRequest) (<-chan *LoginInstanceResponse, <-chan error) {
	responseChan := make(chan *LoginInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.LoginInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// LoginInstanceWithCallback invokes the ecs_workbench.LoginInstance API asynchronously
func (client *Client) LoginInstanceWithCallback(request *LoginInstanceRequest, callback func(response *LoginInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *LoginInstanceResponse
		var err error
		defer close(result)
		response, err = client.LoginInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// LoginInstanceRequest is the request struct for api LoginInstance
type LoginInstanceRequest struct {
	*requests.RpcRequest
	PartnerInfo       LoginInstancePartnerInfo       `position:"Query" name:"PartnerInfo"  type:"Struct"`
	InstanceLoginInfo LoginInstanceInstanceLoginInfo `position:"Query" name:"InstanceLoginInfo"  type:"Struct"`
	UserAccount       LoginInstanceUserAccount       `position:"Query" name:"UserAccount"  type:"Struct"`
}

// LoginInstancePartnerInfo is a repeated param struct in LoginInstanceRequest
type LoginInstancePartnerInfo struct {
	PartnerName string `name:"PartnerName"`
	PartnerId   string `name:"PartnerId"`
}

// LoginInstanceInstanceLoginInfo is a repeated param struct in LoginInstanceRequest
type LoginInstanceInstanceLoginInfo struct {
	ExpireTime                string                                `name:"ExpireTime"`
	LoginByInstanceShortcut   string                                `name:"LoginByInstanceShortcut"`
	Certificate               string                                `name:"Certificate"`
	AuthenticationType        string                                `name:"AuthenticationType"`
	DockerExec                string                                `name:"DockerExec"`
	ShortcutToken             string                                `name:"ShortcutToken"`
	ResourceGroupId           string                                `name:"ResourceGroupId"`
	Protocol                  string                                `name:"Protocol"`
	Password                  string                                `name:"Password"`
	LoginByInstanceCredential string                                `name:"LoginByInstanceCredential"`
	InstanceId                string                                `name:"InstanceId"`
	RegionId                  string                                `name:"RegionId"`
	Port                      string                                `name:"Port"`
	VpcId                     string                                `name:"VpcId"`
	Host                      string                                `name:"Host"`
	Options                   LoginInstanceInstanceLoginInfoOptions `name:"Options" type:"Struct"`
	InstanceType              string                                `name:"InstanceType"`
	DockerContainerName       string                                `name:"DockerContainerName"`
	PassPhrase                string                                `name:"PassPhrase"`
	CredentialToken           string                                `name:"CredentialToken"`
	DurationSeconds           string                                `name:"DurationSeconds"`
	NetworkAccessMode         string                                `name:"NetworkAccessMode"`
	Username                  string                                `name:"Username"`
}

// LoginInstanceUserAccount is a repeated param struct in LoginInstanceRequest
type LoginInstanceUserAccount struct {
	AccountId        string                          `name:"AccountId"`
	EmpId            string                          `name:"EmpId"`
	ExpireTime       string                          `name:"ExpireTime"`
	LoginName        string                          `name:"LoginName"`
	Options          LoginInstanceUserAccountOptions `name:"Options" type:"Struct"`
	AccountStructure string                          `name:"AccountStructure"`
	DurationSeconds  string                          `name:"DurationSeconds"`
	ParentId         string                          `name:"ParentId"`
	AccountPlatform  string                          `name:"AccountPlatform"`
}

// LoginInstanceInstanceLoginInfoOptions is a repeated param struct in LoginInstanceRequest
type LoginInstanceInstanceLoginInfoOptions struct {
	OperationDisableSeconds          string                                             `name:"OperationDisableSeconds"`
	NotificationRecipientUrl         string                                             `name:"NotificationRecipientUrl"`
	SessionControl                   string                                             `name:"SessionControl"`
	VideoFreezeSeconds               string                                             `name:"VideoFreezeSeconds"`
	ContainerInfo                    LoginInstanceInstanceLoginInfoOptionsContainerInfo `name:"ContainerInfo" type:"Struct"`
	NotificationRetryIntervalSeconds string                                             `name:"NotificationRetryIntervalSeconds"`
	AudioMuteSeconds                 string                                             `name:"AudioMuteSeconds"`
	FixedHeight                      string                                             `name:"FixedHeight"`
	FixedWidth                       string                                             `name:"FixedWidth"`
	NotificationEventTypes           string                                             `name:"NotificationEventTypes"`
	NotificationRetryLimit           string                                             `name:"NotificationRetryLimit"`
}

// LoginInstanceUserAccountOptions is a repeated param struct in LoginInstanceRequest
type LoginInstanceUserAccountOptions struct {
	LoginLimit string `name:"LoginLimit"`
}

// LoginInstanceInstanceLoginInfoOptionsContainerInfo is a repeated param struct in LoginInstanceRequest
type LoginInstanceInstanceLoginInfoOptionsContainerInfo struct {
	Headers       map[string]string `name:"Headers" type:"Map"`
	Endpoint      string            `name:"Endpoint"`
	ContainerName string            `name:"ContainerName"`
	ClusterName   string            `name:"ClusterName"`
	Namespace     string            `name:"Namespace"`
	PodName       string            `name:"PodName"`
	ClusterId     string            `name:"ClusterId"`
	Deployment    string            `name:"Deployment"`
}

// LoginInstanceResponse is the response struct for api LoginInstance
type LoginInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   string `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Root      Root   `json:"Root" xml:"Root"`
}

// CreateLoginInstanceRequest creates a request to invoke LoginInstance API
func CreateLoginInstanceRequest() (request *LoginInstanceRequest) {
	request = &LoginInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecs-workbench", "2022-02-20", "LoginInstance", "ecs-workbench", "openAPI")
	request.Method = requests.POST
	return
}

// CreateLoginInstanceResponse creates a response to parse from LoginInstance response
func CreateLoginInstanceResponse() (response *LoginInstanceResponse) {
	response = &LoginInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
