package eas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateServiceMirror invokes the eas.UpdateServiceMirror API synchronously
func (client *Client) UpdateServiceMirror(request *UpdateServiceMirrorRequest) (response *UpdateServiceMirrorResponse, err error) {
	response = CreateUpdateServiceMirrorResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateServiceMirrorWithChan invokes the eas.UpdateServiceMirror API asynchronously
func (client *Client) UpdateServiceMirrorWithChan(request *UpdateServiceMirrorRequest) (<-chan *UpdateServiceMirrorResponse, <-chan error) {
	responseChan := make(chan *UpdateServiceMirrorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateServiceMirror(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateServiceMirrorWithCallback invokes the eas.UpdateServiceMirror API asynchronously
func (client *Client) UpdateServiceMirrorWithCallback(request *UpdateServiceMirrorRequest, callback func(response *UpdateServiceMirrorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateServiceMirrorResponse
		var err error
		defer close(result)
		response, err = client.UpdateServiceMirror(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateServiceMirrorRequest is the request struct for api UpdateServiceMirror
type UpdateServiceMirrorRequest struct {
	*requests.RoaRequest
	ServiceName string `position:"Path" name:"ServiceName"`
	ClusterId   string `position:"Path" name:"ClusterId"`
	Body        string `position:"Body" name:"body"`
}

// UpdateServiceMirrorResponse is the response struct for api UpdateServiceMirror
type UpdateServiceMirrorResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateUpdateServiceMirrorRequest creates a request to invoke UpdateServiceMirror API
func CreateUpdateServiceMirrorRequest() (request *UpdateServiceMirrorRequest) {
	request = &UpdateServiceMirrorRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("eas", "2021-07-01", "UpdateServiceMirror", "/api/v2/services/[ClusterId]/[ServiceName]/mirror", "eas", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateUpdateServiceMirrorResponse creates a response to parse from UpdateServiceMirror response
func CreateUpdateServiceMirrorResponse() (response *UpdateServiceMirrorResponse) {
	response = &UpdateServiceMirrorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
