package dyvmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CancelRobotTask invokes the dyvmsapi.CancelRobotTask API synchronously
func (client *Client) CancelRobotTask(request *CancelRobotTaskRequest) (response *CancelRobotTaskResponse, err error) {
	response = CreateCancelRobotTaskResponse()
	err = client.DoAction(request, response)
	return
}

// CancelRobotTaskWithChan invokes the dyvmsapi.CancelRobotTask API asynchronously
func (client *Client) CancelRobotTaskWithChan(request *CancelRobotTaskRequest) (<-chan *CancelRobotTaskResponse, <-chan error) {
	responseChan := make(chan *CancelRobotTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CancelRobotTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CancelRobotTaskWithCallback invokes the dyvmsapi.CancelRobotTask API asynchronously
func (client *Client) CancelRobotTaskWithCallback(request *CancelRobotTaskRequest, callback func(response *CancelRobotTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CancelRobotTaskResponse
		var err error
		defer close(result)
		response, err = client.CancelRobotTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CancelRobotTaskRequest is the request struct for api CancelRobotTask
type CancelRobotTaskRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	TaskId               requests.Integer `position:"Query" name:"TaskId"`
}

// CancelRobotTaskResponse is the response struct for api CancelRobotTask
type CancelRobotTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateCancelRobotTaskRequest creates a request to invoke CancelRobotTask API
func CreateCancelRobotTaskRequest() (request *CancelRobotTaskRequest) {
	request = &CancelRobotTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyvmsapi", "2017-05-25", "CancelRobotTask", "dyvms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCancelRobotTaskResponse creates a response to parse from CancelRobotTask response
func CreateCancelRobotTaskResponse() (response *CancelRobotTaskResponse) {
	response = &CancelRobotTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
