package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDrdsInstanceLevelTasks invokes the drds.DescribeDrdsInstanceLevelTasks API synchronously
func (client *Client) DescribeDrdsInstanceLevelTasks(request *DescribeDrdsInstanceLevelTasksRequest) (response *DescribeDrdsInstanceLevelTasksResponse, err error) {
	response = CreateDescribeDrdsInstanceLevelTasksResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDrdsInstanceLevelTasksWithChan invokes the drds.DescribeDrdsInstanceLevelTasks API asynchronously
func (client *Client) DescribeDrdsInstanceLevelTasksWithChan(request *DescribeDrdsInstanceLevelTasksRequest) (<-chan *DescribeDrdsInstanceLevelTasksResponse, <-chan error) {
	responseChan := make(chan *DescribeDrdsInstanceLevelTasksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDrdsInstanceLevelTasks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDrdsInstanceLevelTasksWithCallback invokes the drds.DescribeDrdsInstanceLevelTasks API asynchronously
func (client *Client) DescribeDrdsInstanceLevelTasksWithCallback(request *DescribeDrdsInstanceLevelTasksRequest, callback func(response *DescribeDrdsInstanceLevelTasksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDrdsInstanceLevelTasksResponse
		var err error
		defer close(result)
		response, err = client.DescribeDrdsInstanceLevelTasks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDrdsInstanceLevelTasksRequest is the request struct for api DescribeDrdsInstanceLevelTasks
type DescribeDrdsInstanceLevelTasksRequest struct {
	*requests.RpcRequest
	DrdsInstanceId string `position:"Query" name:"DrdsInstanceId"`
}

// DescribeDrdsInstanceLevelTasksResponse is the response struct for api DescribeDrdsInstanceLevelTasks
type DescribeDrdsInstanceLevelTasksResponse struct {
	*responses.BaseResponse
	Success   bool                                  `json:"Success" xml:"Success"`
	RequestId string                                `json:"RequestId" xml:"RequestId"`
	Tasks     TasksInDescribeDrdsInstanceLevelTasks `json:"Tasks" xml:"Tasks"`
}

// CreateDescribeDrdsInstanceLevelTasksRequest creates a request to invoke DescribeDrdsInstanceLevelTasks API
func CreateDescribeDrdsInstanceLevelTasksRequest() (request *DescribeDrdsInstanceLevelTasksRequest) {
	request = &DescribeDrdsInstanceLevelTasksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "DescribeDrdsInstanceLevelTasks", "drds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDrdsInstanceLevelTasksResponse creates a response to parse from DescribeDrdsInstanceLevelTasks response
func CreateDescribeDrdsInstanceLevelTasksResponse() (response *DescribeDrdsInstanceLevelTasksResponse) {
	response = &DescribeDrdsInstanceLevelTasksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
