package domain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitDomainSpecialBizCredentials invokes the domain.SubmitDomainSpecialBizCredentials API synchronously
func (client *Client) SubmitDomainSpecialBizCredentials(request *SubmitDomainSpecialBizCredentialsRequest) (response *SubmitDomainSpecialBizCredentialsResponse, err error) {
	response = CreateSubmitDomainSpecialBizCredentialsResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitDomainSpecialBizCredentialsWithChan invokes the domain.SubmitDomainSpecialBizCredentials API asynchronously
func (client *Client) SubmitDomainSpecialBizCredentialsWithChan(request *SubmitDomainSpecialBizCredentialsRequest) (<-chan *SubmitDomainSpecialBizCredentialsResponse, <-chan error) {
	responseChan := make(chan *SubmitDomainSpecialBizCredentialsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitDomainSpecialBizCredentials(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitDomainSpecialBizCredentialsWithCallback invokes the domain.SubmitDomainSpecialBizCredentials API asynchronously
func (client *Client) SubmitDomainSpecialBizCredentialsWithCallback(request *SubmitDomainSpecialBizCredentialsRequest, callback func(response *SubmitDomainSpecialBizCredentialsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitDomainSpecialBizCredentialsResponse
		var err error
		defer close(result)
		response, err = client.SubmitDomainSpecialBizCredentials(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitDomainSpecialBizCredentialsRequest is the request struct for api SubmitDomainSpecialBizCredentials
type SubmitDomainSpecialBizCredentialsRequest struct {
	*requests.RpcRequest
	Credentials  string           `position:"Body" name:"Credentials"`
	Extend       string           `position:"Body" name:"Extend"`
	BizId        requests.Integer `position:"Body" name:"BizId"`
	UserClientIp string           `position:"Query" name:"UserClientIp"`
}

// SubmitDomainSpecialBizCredentialsResponse is the response struct for api SubmitDomainSpecialBizCredentials
type SubmitDomainSpecialBizCredentialsResponse struct {
	*responses.BaseResponse
}

// CreateSubmitDomainSpecialBizCredentialsRequest creates a request to invoke SubmitDomainSpecialBizCredentials API
func CreateSubmitDomainSpecialBizCredentialsRequest() (request *SubmitDomainSpecialBizCredentialsRequest) {
	request = &SubmitDomainSpecialBizCredentialsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain", "2018-01-29", "SubmitDomainSpecialBizCredentials", "domain", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSubmitDomainSpecialBizCredentialsResponse creates a response to parse from SubmitDomainSpecialBizCredentials response
func CreateSubmitDomainSpecialBizCredentialsResponse() (response *SubmitDomainSpecialBizCredentialsResponse) {
	response = &SubmitDomainSpecialBizCredentialsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
