package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeHeaders invokes the ddoscoo.DescribeHeaders API synchronously
func (client *Client) DescribeHeaders(request *DescribeHeadersRequest) (response *DescribeHeadersResponse, err error) {
	response = CreateDescribeHeadersResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeHeadersWithChan invokes the ddoscoo.DescribeHeaders API asynchronously
func (client *Client) DescribeHeadersWithChan(request *DescribeHeadersRequest) (<-chan *DescribeHeadersResponse, <-chan error) {
	responseChan := make(chan *DescribeHeadersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeHeaders(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeHeadersWithCallback invokes the ddoscoo.DescribeHeaders API asynchronously
func (client *Client) DescribeHeadersWithCallback(request *DescribeHeadersRequest, callback func(response *DescribeHeadersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeHeadersResponse
		var err error
		defer close(result)
		response, err = client.DescribeHeaders(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeHeadersRequest is the request struct for api DescribeHeaders
type DescribeHeadersRequest struct {
	*requests.RpcRequest
	ResourceGroupId string `position:"Query" name:"ResourceGroupId"`
	SourceIp        string `position:"Query" name:"SourceIp"`
	Domain          string `position:"Query" name:"Domain"`
}

// DescribeHeadersResponse is the response struct for api DescribeHeaders
type DescribeHeadersResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	CustomHeader CustomHeader `json:"CustomHeader" xml:"CustomHeader"`
}

// CreateDescribeHeadersRequest creates a request to invoke DescribeHeaders API
func CreateDescribeHeadersRequest() (request *DescribeHeadersRequest) {
	request = &DescribeHeadersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DescribeHeaders", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeHeadersResponse creates a response to parse from DescribeHeaders response
func CreateDescribeHeadersResponse() (response *DescribeHeadersResponse) {
	response = &DescribeHeadersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
