package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDomainViewTopUrl invokes the ddoscoo.DescribeDomainViewTopUrl API synchronously
func (client *Client) DescribeDomainViewTopUrl(request *DescribeDomainViewTopUrlRequest) (response *DescribeDomainViewTopUrlResponse, err error) {
	response = CreateDescribeDomainViewTopUrlResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDomainViewTopUrlWithChan invokes the ddoscoo.DescribeDomainViewTopUrl API asynchronously
func (client *Client) DescribeDomainViewTopUrlWithChan(request *DescribeDomainViewTopUrlRequest) (<-chan *DescribeDomainViewTopUrlResponse, <-chan error) {
	responseChan := make(chan *DescribeDomainViewTopUrlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDomainViewTopUrl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDomainViewTopUrlWithCallback invokes the ddoscoo.DescribeDomainViewTopUrl API asynchronously
func (client *Client) DescribeDomainViewTopUrlWithCallback(request *DescribeDomainViewTopUrlRequest, callback func(response *DescribeDomainViewTopUrlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDomainViewTopUrlResponse
		var err error
		defer close(result)
		response, err = client.DescribeDomainViewTopUrl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDomainViewTopUrlRequest is the request struct for api DescribeDomainViewTopUrl
type DescribeDomainViewTopUrlRequest struct {
	*requests.RpcRequest
	StartTime       requests.Integer `position:"Query" name:"StartTime"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	Top             requests.Integer `position:"Query" name:"Top"`
	EndTime         requests.Integer `position:"Query" name:"EndTime"`
	Domain          string           `position:"Query" name:"Domain"`
}

// DescribeDomainViewTopUrlResponse is the response struct for api DescribeDomainViewTopUrl
type DescribeDomainViewTopUrlResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	UrlList   []Url  `json:"UrlList" xml:"UrlList"`
}

// CreateDescribeDomainViewTopUrlRequest creates a request to invoke DescribeDomainViewTopUrl API
func CreateDescribeDomainViewTopUrlRequest() (request *DescribeDomainViewTopUrlRequest) {
	request = &DescribeDomainViewTopUrlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DescribeDomainViewTopUrl", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDomainViewTopUrlResponse creates a response to parse from DescribeDomainViewTopUrl response
func CreateDescribeDomainViewTopUrlResponse() (response *DescribeDomainViewTopUrlResponse) {
	response = &DescribeDomainViewTopUrlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
