package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDDosEventSrcIp invokes the ddoscoo.DescribeDDosEventSrcIp API synchronously
func (client *Client) DescribeDDosEventSrcIp(request *DescribeDDosEventSrcIpRequest) (response *DescribeDDosEventSrcIpResponse, err error) {
	response = CreateDescribeDDosEventSrcIpResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDDosEventSrcIpWithChan invokes the ddoscoo.DescribeDDosEventSrcIp API asynchronously
func (client *Client) DescribeDDosEventSrcIpWithChan(request *DescribeDDosEventSrcIpRequest) (<-chan *DescribeDDosEventSrcIpResponse, <-chan error) {
	responseChan := make(chan *DescribeDDosEventSrcIpResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDDosEventSrcIp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDDosEventSrcIpWithCallback invokes the ddoscoo.DescribeDDosEventSrcIp API asynchronously
func (client *Client) DescribeDDosEventSrcIpWithCallback(request *DescribeDDosEventSrcIpRequest, callback func(response *DescribeDDosEventSrcIpResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDDosEventSrcIpResponse
		var err error
		defer close(result)
		response, err = client.DescribeDDosEventSrcIp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDDosEventSrcIpRequest is the request struct for api DescribeDDosEventSrcIp
type DescribeDDosEventSrcIpRequest struct {
	*requests.RpcRequest
	Ip        string           `position:"Query" name:"Ip"`
	Range     requests.Integer `position:"Query" name:"Range"`
	StartTime requests.Integer `position:"Query" name:"StartTime"`
	SourceIp  string           `position:"Query" name:"SourceIp"`
	EventType string           `position:"Query" name:"EventType"`
}

// DescribeDDosEventSrcIpResponse is the response struct for api DescribeDDosEventSrcIp
type DescribeDDosEventSrcIpResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	Ips       []EventSrcIp `json:"Ips" xml:"Ips"`
}

// CreateDescribeDDosEventSrcIpRequest creates a request to invoke DescribeDDosEventSrcIp API
func CreateDescribeDDosEventSrcIpRequest() (request *DescribeDDosEventSrcIpRequest) {
	request = &DescribeDDosEventSrcIpRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DescribeDDosEventSrcIp", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDDosEventSrcIpResponse creates a response to parse from DescribeDDosEventSrcIp response
func CreateDescribeDDosEventSrcIpResponse() (response *DescribeDDosEventSrcIpResponse) {
	response = &DescribeDDosEventSrcIpResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
