package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateWebRule invokes the ddoscoo.CreateWebRule API synchronously
func (client *Client) CreateWebRule(request *CreateWebRuleRequest) (response *CreateWebRuleResponse, err error) {
	response = CreateCreateWebRuleResponse()
	err = client.DoAction(request, response)
	return
}

// CreateWebRuleWithChan invokes the ddoscoo.CreateWebRule API asynchronously
func (client *Client) CreateWebRuleWithChan(request *CreateWebRuleRequest) (<-chan *CreateWebRuleResponse, <-chan error) {
	responseChan := make(chan *CreateWebRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateWebRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateWebRuleWithCallback invokes the ddoscoo.CreateWebRule API asynchronously
func (client *Client) CreateWebRuleWithCallback(request *CreateWebRuleRequest, callback func(response *CreateWebRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateWebRuleResponse
		var err error
		defer close(result)
		response, err = client.CreateWebRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateWebRuleRequest is the request struct for api CreateWebRule
type CreateWebRuleRequest struct {
	*requests.RpcRequest
	HttpsExt        string           `position:"Query" name:"HttpsExt"`
	Rules           string           `position:"Query" name:"Rules"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	RsType          requests.Integer `position:"Query" name:"RsType"`
	DefenseId       string           `position:"Query" name:"DefenseId"`
	InstanceIds     *[]string        `position:"Query" name:"InstanceIds"  type:"Repeated"`
	Domain          string           `position:"Query" name:"Domain"`
}

// CreateWebRuleResponse is the response struct for api CreateWebRule
type CreateWebRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateWebRuleRequest creates a request to invoke CreateWebRule API
func CreateCreateWebRuleRequest() (request *CreateWebRuleRequest) {
	request = &CreateWebRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "CreateWebRule", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateWebRuleResponse creates a response to parse from CreateWebRule response
func CreateCreateWebRuleResponse() (response *CreateWebRuleResponse) {
	response = &CreateWebRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
